/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.config.jsr223;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.scripting.config.AbstractScriptParser;
import org.springframework.integration.scripting.jsr223.ScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.jsr223.ScriptExecutorFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ScriptParser
extends AbstractScriptParser {
    private static final String LANGUAGE_ATTRIBUTE = "lang";

    protected Class<?> getBeanClass(Element element) {
        return ScriptExecutingMessageProcessor.class;
    }

    @Override
    protected void postProcess(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        String language = element.getAttribute(LANGUAGE_ATTRIBUTE);
        String scriptLocation = element.getAttribute("location");
        if (!StringUtils.hasText((String)language)) {
            if (!StringUtils.hasText((String)scriptLocation)) {
                parserContext.getReaderContext().error("An inline script requires the 'lang' attribute.", (Object)element);
            } else {
                language = ScriptExecutorFactory.deriveLanguageFromFileExtension(scriptLocation);
            }
        }
        builder.addConstructorArgValue((Object)ScriptExecutorFactory.getScriptExecutor(language));
    }
}

