/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;

public class RefreshableResourceScriptSource
implements ScriptSource {
    private final long refreshDelay;
    private final ResourceScriptSource source;
    private final AtomicLong lastModifiedChecked = new AtomicLong(System.currentTimeMillis());
    private volatile String script;

    public RefreshableResourceScriptSource(Resource resource, long refreshDelay) {
        this.refreshDelay = refreshDelay;
        this.source = new ResourceScriptSource(resource);
        try {
            this.script = this.source.getScriptAsString();
        }
        catch (IOException e) {
            this.lastModifiedChecked.set(0L);
        }
    }

    public String getScriptAsString() throws IOException {
        this.script = this.source.getScriptAsString();
        return this.script;
    }

    public String suggestedClassName() {
        return this.source.suggestedClassName();
    }

    public boolean isModified() {
        if (this.refreshDelay < 0L) {
            return false;
        }
        long time = System.currentTimeMillis();
        if (this.refreshDelay == 0L || time - this.lastModifiedChecked.get() > this.refreshDelay) {
            this.lastModifiedChecked.set(time);
            return this.source.isModified();
        }
        return false;
    }
}

