/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.util;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.integration.support.locks.ExpirableLockRegistry;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public final class RedisLockRegistry
implements ExpirableLockRegistry,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(RedisLockRegistry.class);
    private static final long DEFAULT_EXPIRE_AFTER = 60000L;
    private static final int DEFAULT_CAPACITY = 100000;
    private final Lock lock = new ReentrantLock();
    private final Map<String, RedisLock> locks = new LinkedHashMap<String, RedisLock>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RedisLock> eldest) {
            return this.size() > RedisLockRegistry.this.cacheCapacity;
        }
    };
    private final String clientId = UUID.randomUUID().toString();
    private final String registryKey;
    private final String unLockChannelKey;
    private final StringRedisTemplate redisTemplate;
    private final long expireAfter;
    private int cacheCapacity = 100000;
    private RedisLockType redisLockType = RedisLockType.SPIN_LOCK;
    private Executor executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("redis-lock-registry-"));
    private boolean executorExplicitlySet;
    private volatile boolean unlinkAvailable = true;
    private volatile boolean isRunningRedisMessageListenerContainer = false;
    private volatile RedisPubSubLock.RedisUnLockNotifyMessageListener unlockNotifyMessageListener;
    private volatile RedisMessageListenerContainer redisMessageListenerContainer;

    public RedisLockRegistry(RedisConnectionFactory connectionFactory, String registryKey) {
        this(connectionFactory, registryKey, 60000L);
    }

    public RedisLockRegistry(RedisConnectionFactory connectionFactory, String registryKey, long expireAfter) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' cannot be null");
        Assert.notNull((Object)registryKey, (String)"'registryKey' cannot be null");
        this.redisTemplate = new StringRedisTemplate(connectionFactory);
        this.registryKey = registryKey;
        this.expireAfter = expireAfter;
        this.unLockChannelKey = registryKey + "-channel";
    }

    private void setupUnlockMessageListener(RedisConnectionFactory connectionFactory) {
        Assert.isNull((Object)this.redisMessageListenerContainer, (String)"'redisMessageListenerContainer' must not have been re-initialized.");
        Assert.isNull((Object)this.unlockNotifyMessageListener, (String)"'unlockNotifyMessageListener' must not have been re-initialized.");
        this.redisMessageListenerContainer = new RedisMessageListenerContainer();
        this.unlockNotifyMessageListener = new RedisPubSubLock.RedisUnLockNotifyMessageListener();
        ChannelTopic topic = new ChannelTopic(this.unLockChannelKey);
        this.redisMessageListenerContainer.setConnectionFactory(connectionFactory);
        this.redisMessageListenerContainer.setTaskExecutor(this.executor);
        this.redisMessageListenerContainer.setSubscriptionExecutor(this.executor);
        this.redisMessageListenerContainer.addMessageListener((MessageListener)this.unlockNotifyMessageListener, (Topic)topic);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.executorExplicitlySet = true;
        this.redisMessageListenerContainer.setTaskExecutor(this.executor);
        this.redisMessageListenerContainer.setSubscriptionExecutor(this.executor);
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setRedisLockType(RedisLockType redisLockType) {
        Assert.notNull((Object)((Object)redisLockType), (String)"'redisLockType' cannot be null");
        this.redisLockType = redisLockType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock obtain(Object lockKey) {
        Assert.isInstanceOf(String.class, (Object)lockKey);
        String path = (String)lockKey;
        this.lock.lock();
        try {
            Lock lock = this.locks.computeIfAbsent(path, this.getRedisLockConstructor(this.redisLockType));
            return lock;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireUnusedOlderThan(long age) {
        long now = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.locks.entrySet().removeIf(entry -> {
                RedisLock lock = (RedisLock)entry.getValue();
                long lockedAt = lock.getLockedAt();
                return now - lockedAt > age && lockedAt > 0L && !lock.isAcquiredInThisProcess();
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        if (!this.executorExplicitlySet) {
            ((ExecutorService)this.executor).shutdown();
        }
        if (this.redisMessageListenerContainer != null) {
            try {
                this.redisMessageListenerContainer.destroy();
                this.redisMessageListenerContainer = null;
                this.isRunningRedisMessageListenerContainer = false;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private Function<String, RedisLock> getRedisLockConstructor(RedisLockType redisLockType) {
        return switch (redisLockType) {
            default -> throw new IncompatibleClassChangeError();
            case RedisLockType.SPIN_LOCK -> x$0 -> new RedisSpinLock((String)x$0);
            case RedisLockType.PUB_SUB_LOCK -> x$0 -> new RedisPubSubLock((String)x$0);
        };
    }

    public static enum RedisLockType {
        SPIN_LOCK,
        PUB_SUB_LOCK;

    }

    private final class RedisPubSubLock
    extends RedisLock {
        private static final String UNLINK_UNLOCK_SCRIPT = "local lockClientId = redis.call('GET', KEYS[1])\nif (lockClientId == ARGV[1] and redis.call('UNLINK', KEYS[1]) == 1) then\n\tredis.call('PUBLISH', ARGV[2], KEYS[1])\n\treturn true\nend\nreturn false\n";
        private static final String DELETE_UNLOCK_SCRIPT = "local lockClientId = redis.call('GET', KEYS[1])\nif (lockClientId == ARGV[1] and redis.call('DEL', KEYS[1]) == 1) then\n\tredis.call('PUBLISH', ARGV[2], KEYS[1])\n\treturn true\nend\nreturn false\n";
        private static final RedisScript<Boolean> UNLINK_UNLOCK_REDIS_SCRIPT = new DefaultRedisScript("local lockClientId = redis.call('GET', KEYS[1])\nif (lockClientId == ARGV[1] and redis.call('UNLINK', KEYS[1]) == 1) then\n\tredis.call('PUBLISH', ARGV[2], KEYS[1])\n\treturn true\nend\nreturn false\n", Boolean.class);
        private static final RedisScript<Boolean> DELETE_UNLOCK_REDIS_SCRIPT = new DefaultRedisScript("local lockClientId = redis.call('GET', KEYS[1])\nif (lockClientId == ARGV[1] and redis.call('DEL', KEYS[1]) == 1) then\n\tredis.call('PUBLISH', ARGV[2], KEYS[1])\n\treturn true\nend\nreturn false\n", Boolean.class);

        private RedisPubSubLock(String path) {
            super(path);
        }

        @Override
        protected boolean tryRedisLockInner(long time) throws ExecutionException, InterruptedException {
            return this.subscribeLock(time);
        }

        @Override
        protected boolean removeLockKeyInnerUnlink() {
            return this.removeLockKeyWithScript(UNLINK_UNLOCK_REDIS_SCRIPT);
        }

        @Override
        protected boolean removeLockKeyInnerDelete() {
            return this.removeLockKeyWithScript(DELETE_UNLOCK_REDIS_SCRIPT);
        }

        private boolean removeLockKeyWithScript(RedisScript<Boolean> redisScript) {
            return Boolean.TRUE.equals(RedisLockRegistry.this.redisTemplate.execute(redisScript, Collections.singletonList(this.lockKey), new Object[]{RedisLockRegistry.this.clientId, RedisLockRegistry.this.unLockChannelKey}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean subscribeLock(long time) throws ExecutionException, InterruptedException {
            long expiredTime = System.currentTimeMillis() + time;
            if (this.obtainLock().booleanValue()) {
                return true;
            }
            if (!RedisLockRegistry.this.isRunningRedisMessageListenerContainer || RedisLockRegistry.this.redisMessageListenerContainer == null || !RedisLockRegistry.this.redisMessageListenerContainer.isRunning()) {
                this.runRedisMessageListenerContainer();
            }
            while (time == -1L || expiredTime >= System.currentTimeMillis()) {
                try {
                    Future<String> future = RedisLockRegistry.this.unlockNotifyMessageListener.subscribeLock(this.lockKey);
                    if (this.obtainLock().booleanValue()) {
                        boolean bl = true;
                        return bl;
                    }
                    try {
                        long waitTime = time >= 0L ? time : RedisLockRegistry.this.expireAfter;
                        future.get(waitTime, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    if (!this.obtainLock().booleanValue()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    RedisLockRegistry.this.unlockNotifyMessageListener.unSubscribeLock(this.lockKey);
                }
            }
            return false;
        }

        private void runRedisMessageListenerContainer() {
            RedisLockRegistry.this.lock.tryLock();
            try {
                if (!RedisLockRegistry.this.isRunningRedisMessageListenerContainer || RedisLockRegistry.this.redisMessageListenerContainer == null || !RedisLockRegistry.this.redisMessageListenerContainer.isRunning()) {
                    if (RedisLockRegistry.this.redisMessageListenerContainer == null) {
                        RedisLockRegistry.this.setupUnlockMessageListener(RedisLockRegistry.this.redisTemplate.getConnectionFactory());
                        RedisLockRegistry.this.redisMessageListenerContainer.afterPropertiesSet();
                    }
                    RedisLockRegistry.this.redisMessageListenerContainer.start();
                    RedisLockRegistry.this.isRunningRedisMessageListenerContainer = true;
                }
            }
            finally {
                RedisLockRegistry.this.lock.unlock();
            }
        }

        private static final class RedisUnLockNotifyMessageListener
        implements MessageListener {
            private final Map<String, CompletableFuture<String>> notifyMap = new ConcurrentHashMap<String, CompletableFuture<String>>();

            private RedisUnLockNotifyMessageListener() {
            }

            public void onMessage(Message message, byte[] pattern) {
                String lockKey = new String(message.getBody());
                this.unlockNotify(lockKey);
            }

            public Future<String> subscribeLock(String lockKey) {
                return this.notifyMap.computeIfAbsent(lockKey, key -> new CompletableFuture());
            }

            public void unSubscribeLock(String localLock) {
                this.notifyMap.remove(localLock);
            }

            private void unlockNotify(String lockKey) {
                this.notifyMap.computeIfPresent(lockKey, (key, lockFuture) -> {
                    lockFuture.complete(key);
                    return lockFuture;
                });
            }
        }
    }

    private final class RedisSpinLock
    extends RedisLock {
        private static final String UNLINK_UNLOCK_SCRIPT = "local lockClientId = redis.call('GET', KEYS[1])\nif lockClientId == ARGV[1] then\n\tredis.call('UNLINK', KEYS[1])\n\treturn true\nend\nreturn false\n";
        private static final String DELETE_UNLOCK_SCRIPT = "local lockClientId = redis.call('GET', KEYS[1])\nif lockClientId == ARGV[1] then\n\tredis.call('DEL', KEYS[1])\n\treturn true\nend\nreturn false\n";
        private static final RedisScript<Boolean> UNLINK_UNLOCK_REDIS_SCRIPT = new DefaultRedisScript("local lockClientId = redis.call('GET', KEYS[1])\nif lockClientId == ARGV[1] then\n\tredis.call('UNLINK', KEYS[1])\n\treturn true\nend\nreturn false\n", Boolean.class);
        private static final RedisScript<Boolean> DELETE_UNLOCK_REDIS_SCRIPT = new DefaultRedisScript("local lockClientId = redis.call('GET', KEYS[1])\nif lockClientId == ARGV[1] then\n\tredis.call('DEL', KEYS[1])\n\treturn true\nend\nreturn false\n", Boolean.class);

        private RedisSpinLock(String path) {
            super(path);
        }

        @Override
        protected boolean tryRedisLockInner(long time) throws InterruptedException {
            boolean acquired;
            long now = System.currentTimeMillis();
            if (time == -1L) {
                while (!this.obtainLock().booleanValue()) {
                    Thread.sleep(100L);
                }
                return true;
            }
            long expire = now + TimeUnit.MILLISECONDS.convert(time, TimeUnit.MILLISECONDS);
            while (!(acquired = this.obtainLock().booleanValue()) && System.currentTimeMillis() < expire) {
                Thread.sleep(100L);
            }
            return acquired;
        }

        @Override
        protected boolean removeLockKeyInnerUnlink() {
            return this.removeLockKeyWithScript(UNLINK_UNLOCK_REDIS_SCRIPT);
        }

        @Override
        protected boolean removeLockKeyInnerDelete() {
            return this.removeLockKeyWithScript(DELETE_UNLOCK_REDIS_SCRIPT);
        }

        private boolean removeLockKeyWithScript(RedisScript<Boolean> redisScript) {
            return Boolean.TRUE.equals(RedisLockRegistry.this.redisTemplate.execute(redisScript, Collections.singletonList(this.lockKey), new Object[]{RedisLockRegistry.this.clientId}));
        }
    }

    private abstract class RedisLock
    implements Lock {
        private static final String OBTAIN_LOCK_SCRIPT = "local lockClientId = redis.call('GET', KEYS[1])\nif lockClientId == ARGV[1] then\n\tredis.call('PEXPIRE', KEYS[1], ARGV[2])\n\treturn true\nelseif not lockClientId then\n\tredis.call('SET', KEYS[1], ARGV[1], 'PX', ARGV[2])\n\treturn true\nend\nreturn false\n";
        protected static final RedisScript<Boolean> OBTAIN_LOCK_REDIS_SCRIPT = new DefaultRedisScript("local lockClientId = redis.call('GET', KEYS[1])\nif lockClientId == ARGV[1] then\n\tredis.call('PEXPIRE', KEYS[1], ARGV[2])\n\treturn true\nelseif not lockClientId then\n\tredis.call('SET', KEYS[1], ARGV[1], 'PX', ARGV[2])\n\treturn true\nend\nreturn false\n", Boolean.class);
        protected final String lockKey;
        private final ReentrantLock localLock = new ReentrantLock();
        private volatile long lockedAt;

        private RedisLock(String path) {
            this.lockKey = this.constructLockKey(path);
        }

        private String constructLockKey(String path) {
            return RedisLockRegistry.this.registryKey + ":" + path;
        }

        public long getLockedAt() {
            return this.lockedAt;
        }

        protected abstract boolean tryRedisLockInner(long var1) throws ExecutionException, InterruptedException;

        protected abstract boolean removeLockKeyInnerUnlink();

        protected abstract boolean removeLockKeyInnerDelete();

        @Override
        public final void lock() {
            this.localLock.lock();
            while (true) {
                try {
                    while (!this.tryRedisLock(-1L)) {
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    this.localLock.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        private void rethrowAsLockException(Exception e) {
            throw new CannotAcquireLockException("Failed to lock mutex at " + this.lockKey, (Throwable)e);
        }

        @Override
        public final void lockInterruptibly() throws InterruptedException {
            this.localLock.lockInterruptibly();
            while (true) {
                try {
                    while (!this.tryRedisLock(-1L)) {
                    }
                    return;
                }
                catch (InterruptedException ie) {
                    this.localLock.unlock();
                    Thread.currentThread().interrupt();
                    throw ie;
                }
                catch (Exception e) {
                    this.localLock.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        @Override
        public final boolean tryLock() {
            try {
                return this.tryLock(0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public final boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            if (!this.localLock.tryLock(time, unit)) {
                return false;
            }
            try {
                long waitTime = TimeUnit.MILLISECONDS.convert(time, unit);
                boolean acquired = this.tryRedisLock(waitTime);
                if (!acquired) {
                    this.localLock.unlock();
                }
                return acquired;
            }
            catch (Exception e) {
                this.localLock.unlock();
                this.rethrowAsLockException(e);
                return false;
            }
        }

        private boolean tryRedisLock(long time) throws ExecutionException, InterruptedException {
            boolean result = this.tryRedisLockInner(time);
            if (result) {
                this.lockedAt = System.currentTimeMillis();
            }
            return result;
        }

        protected final Boolean obtainLock() {
            return (Boolean)RedisLockRegistry.this.redisTemplate.execute(OBTAIN_LOCK_REDIS_SCRIPT, Collections.singletonList(this.lockKey), new Object[]{RedisLockRegistry.this.clientId, String.valueOf(RedisLockRegistry.this.expireAfter)});
        }

        @Override
        public final void unlock() {
            if (!this.localLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("You do not own lock at " + this.lockKey);
            }
            if (this.localLock.getHoldCount() > 1) {
                this.localLock.unlock();
                return;
            }
            try {
                if (Thread.currentThread().isInterrupted()) {
                    RedisLockRegistry.this.executor.execute(this::removeLockKey);
                } else {
                    this.removeLockKey();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Released lock; " + this));
                }
            }
            catch (Exception e) {
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            finally {
                this.localLock.unlock();
            }
        }

        private void removeLockKey() {
            if (RedisLockRegistry.this.unlinkAvailable) {
                Boolean unlinkResult = null;
                try {
                    unlinkResult = this.removeLockKeyInnerUnlink();
                }
                catch (Exception ex) {
                    RedisLockRegistry.this.unlinkAvailable = false;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"The UNLINK command has failed (not supported on the Redis server?); falling back to the regular DELETE command", (Throwable)ex);
                    }
                    LOGGER.warn((Object)("The UNLINK command has failed (not supported on the Redis server?); falling back to the regular DELETE command: " + ex.getMessage()));
                }
                if (Boolean.TRUE.equals(unlinkResult)) {
                    return;
                }
                if (Boolean.FALSE.equals(unlinkResult)) {
                    throw new IllegalStateException("Lock was released in the store due to expiration. The integrity of data protected by this lock may have been compromised.");
                }
            }
            if (!this.removeLockKeyInnerDelete()) {
                throw new IllegalStateException("Lock was released in the store due to expiration. The integrity of data protected by this lock may have been compromised.");
            }
        }

        @Override
        public final Condition newCondition() {
            throw new UnsupportedOperationException("Conditions are not supported");
        }

        public final boolean isAcquiredInThisProcess() {
            return this.localLock.isLocked();
        }

        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd@HH:mm:ss.SSS");
            return "RedisLock [lockKey=" + this.lockKey + ",lockedAt=" + dateFormat.format(new Date(this.lockedAt)) + ", clientId=" + RedisLockRegistry.this.clientId + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.lockKey == null ? 0 : this.lockKey.hashCode());
            result = 31 * result + (int)(this.lockedAt ^ this.lockedAt >>> 32);
            result = 31 * result + RedisLockRegistry.this.clientId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RedisLock other = (RedisLock)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (!this.lockKey.equals(other.lockKey)) {
                return false;
            }
            return this.lockedAt == other.lockedAt;
        }

        private RedisLockRegistry getOuterType() {
            return RedisLockRegistry.this;
        }
    }
}

