/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.redis.outbound.ExpressionArgumentsStrategy;
import org.springframework.integration.redis.outbound.RedisOutboundGateway;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedisOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RedisOutboundGateway.class);
        String redisTemplate = element.getAttribute("redis-template");
        String connectionFactory = element.getAttribute("connection-factory");
        if (StringUtils.hasText((String)redisTemplate) && StringUtils.hasText((String)connectionFactory)) {
            parserContext.getReaderContext().error("Only one of '" + redisTemplate + "' or '" + connectionFactory + "' is allowed.", (Object)element);
        }
        if (StringUtils.hasText((String)redisTemplate)) {
            builder.addConstructorArgReference(redisTemplate);
        } else {
            if (!StringUtils.hasText((String)connectionFactory)) {
                connectionFactory = "redisConnectionFactory";
            }
            builder.addConstructorArgReference(connectionFactory);
        }
        String argumentExpressions = element.getAttribute("argument-expressions");
        boolean hasArgumentExpressions = StringUtils.hasText((String)argumentExpressions);
        String argumentsStrategy = element.getAttribute("arguments-strategy");
        boolean hasArgumentStrategy = element.hasAttribute("arguments-strategy");
        if (hasArgumentExpressions & hasArgumentStrategy) {
            parserContext.getReaderContext().error("'argument-expressions' and 'arguments-strategy' are mutually exclusive.", (Object)element);
        }
        if (hasArgumentExpressions) {
            BeanDefinitionBuilder argumentsBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionArgumentsStrategy.class).addConstructorArgValue((Object)argumentExpressions).addConstructorArgValue((Object)element.getAttribute("use-command-variable"));
            builder.addPropertyValue("argumentsStrategy", (Object)argumentsBuilder.getBeanDefinition());
        } else if (StringUtils.hasLength((String)argumentsStrategy)) {
            builder.addPropertyReference("argumentsStrategy", argumentsStrategy);
        } else if (hasArgumentStrategy) {
            builder.addPropertyValue("argumentsStrategy", null);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"requires-reply");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"command-expression");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"arguments-serializer");
        return builder;
    }
}

