/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.core;

import org.eclipse.paho.mqttv5.client.IMqttAsyncClient;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.mqtt.core.AbstractMqttClientManager;
import org.springframework.integration.mqtt.event.MqttConnectionFailedEvent;
import org.springframework.util.Assert;

public class Mqttv5ClientManager
extends AbstractMqttClientManager<IMqttAsyncClient, MqttConnectionOptions>
implements MqttCallback {
    private final MqttConnectionOptions connectionOptions;
    private MqttClientPersistence persistence;

    public Mqttv5ClientManager(String url, String clientId) {
        this(Mqttv5ClientManager.buildDefaultConnectionOptions(url), clientId);
    }

    public Mqttv5ClientManager(MqttConnectionOptions connectionOptions, String clientId) {
        super(clientId);
        Assert.notNull((Object)connectionOptions, (String)"'connectionOptions' is required");
        this.connectionOptions = connectionOptions;
        if (!this.connectionOptions.isAutomaticReconnect()) {
            this.logger.info((Object)"If this `ClientManager` is used from message-driven channel adapters, it is recommended to set 'automaticReconnect' MQTT connection option. Otherwise connection check and reconnect should be done manually.");
        }
        Assert.notEmpty((Object[])connectionOptions.getServerURIs(), (String)"'serverURIs' must be provided in the 'MqttConnectionOptions'");
        this.setUrl(connectionOptions.getServerURIs()[0]);
    }

    private static MqttConnectionOptions buildDefaultConnectionOptions(String url) {
        Assert.notNull((Object)url, (String)"'url' is required");
        MqttConnectionOptions connectionOptions = new MqttConnectionOptions();
        connectionOptions.setServerURIs(new String[]{url});
        connectionOptions.setAutomaticReconnect(true);
        return connectionOptions;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public MqttConnectionOptions getConnectionInfo() {
        return this.connectionOptions;
    }

    public synchronized void start() {
        IMqttAsyncClient client = (IMqttAsyncClient)this.getClient();
        if (client == null) {
            try {
                client = this.createClient();
            }
            catch (MqttException e) {
                throw new IllegalStateException("Could not start client manager", e);
            }
        }
        this.setClient(client);
        try {
            client.connect(this.connectionOptions).waitForCompletion((long)this.connectionOptions.getConnectionTimeout());
        }
        catch (MqttException ex) {
            if (this.connectionOptions.isAutomaticReconnect()) {
                try {
                    client.reconnect();
                }
                catch (MqttException re) {
                    this.logger.error((Object)"MQTT client failed to connect. Never happens.", (Throwable)re);
                }
            }
            ApplicationEventPublisher applicationEventPublisher = this.getApplicationEventPublisher();
            if (applicationEventPublisher != null) {
                applicationEventPublisher.publishEvent((ApplicationEvent)new MqttConnectionFailedEvent(this, ex));
            }
            this.logger.error((Object)("Could not start client manager, client_id=" + this.getClientId()), (Throwable)ex);
        }
    }

    private MqttAsyncClient createClient() throws MqttException {
        String url = this.getUrl();
        String clientId = this.getClientId();
        MqttAsyncClient client = new MqttAsyncClient(url, clientId, this.persistence);
        client.setManualAcks(this.isManualAcks());
        client.setCallback((MqttCallback)this);
        return client;
    }

    public synchronized void stop() {
        IMqttAsyncClient client = (IMqttAsyncClient)this.getClient();
        if (client == null) {
            return;
        }
        try {
            client.disconnectForcibly((long)this.connectionOptions.getConnectionTimeout());
        }
        catch (MqttException e) {
            this.logger.error((Object)"Could not disconnect from the client", (Throwable)e);
        }
        finally {
            try {
                client.close();
            }
            catch (MqttException e) {
                this.logger.error((Object)"Could not close the client", (Throwable)e);
            }
            this.setClient(null);
        }
    }

    public void messageArrived(String topic, MqttMessage message) {
    }

    public void deliveryComplete(IMqttToken token) {
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        this.getCallbacks().forEach(callback -> callback.connectComplete(reconnect));
    }

    public void authPacketArrived(int reasonCode, MqttProperties properties) {
    }

    public void disconnected(MqttDisconnectResponse disconnectResponse) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("MQTT disconnected: " + disconnectResponse));
        }
    }

    public void mqttErrorOccurred(MqttException exception) {
        this.logger.error((Object)"MQTT error occurred", (Throwable)exception);
    }
}

