/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.inbound;

import com.mongodb.DBObject;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReactiveMongoDbMessageSource
extends AbstractMessageSource<Publisher<?>>
implements ApplicationContextAware {
    @Nullable
    private final ReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory;
    private final Expression queryExpression;
    private Expression collectionNameExpression = new LiteralExpression("data");
    private StandardEvaluationContext evaluationContext;
    private ReactiveMongoOperations reactiveMongoTemplate;
    private MongoConverter mongoConverter;
    private Class<?> entityClass = DBObject.class;
    private boolean expectSingleResult = false;
    private ApplicationContext applicationContext;
    private volatile boolean initialized = false;

    public ReactiveMongoDbMessageSource(ReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory, Expression queryExpression) {
        Assert.notNull((Object)reactiveMongoDatabaseFactory, (String)"'reactiveMongoDatabaseFactory' must not be null");
        Assert.notNull((Object)queryExpression, (String)"'queryExpression' must not be null");
        this.reactiveMongoDatabaseFactory = reactiveMongoDatabaseFactory;
        this.queryExpression = queryExpression;
    }

    public ReactiveMongoDbMessageSource(ReactiveMongoOperations reactiveMongoTemplate, Expression queryExpression) {
        Assert.notNull((Object)reactiveMongoTemplate, (String)"'reactiveMongoTemplate' must not be null");
        Assert.notNull((Object)queryExpression, (String)"'queryExpression' must not be null");
        this.reactiveMongoDatabaseFactory = null;
        this.reactiveMongoTemplate = reactiveMongoTemplate;
        this.queryExpression = queryExpression;
    }

    public void setEntityClass(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"'entityClass' must not be null");
        this.entityClass = entityClass;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public void setCollectionNameExpression(Expression collectionNameExpression) {
        Assert.notNull((Object)collectionNameExpression, (String)"'collectionNameExpression' must not be null");
        this.collectionNameExpression = collectionNameExpression;
    }

    public void setMongoConverter(MongoConverter mongoConverter) {
        Assert.isNull((Object)this.reactiveMongoTemplate, (String)"'mongoConverter' can not be set when instance was constructed with ReactiveMongoTemplate");
        this.mongoConverter = mongoConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getComponentType() {
        return "mongo:reactive-inbound-channel-adapter";
    }

    protected void onInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        TypeLocator typeLocator = this.evaluationContext.getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            ((StandardTypeLocator)typeLocator).registerImport("org.springframework.data.mongodb.core.query");
        }
        if (this.reactiveMongoDatabaseFactory != null) {
            ReactiveMongoTemplate template = new ReactiveMongoTemplate(this.reactiveMongoDatabaseFactory, this.mongoConverter);
            if (this.applicationContext != null) {
                template.setApplicationContext(this.applicationContext);
            }
            this.reactiveMongoTemplate = template;
        }
        this.initialized = true;
    }

    public Object doReceive() {
        Assert.isTrue((boolean)this.initialized, (String)"This class is not yet initialized. Invoke its afterPropertiesSet() method");
        Object value = this.queryExpression.getValue((EvaluationContext)this.evaluationContext);
        Assert.notNull((Object)value, (String)"'queryExpression' must not evaluate to null");
        BasicQuery query = null;
        if (value instanceof String) {
            query = new BasicQuery((String)value);
        } else if (value instanceof Query) {
            query = (Query)value;
        } else {
            throw new IllegalStateException("'queryExpression' must evaluate to String or org.springframework.data.mongodb.core.query.Query, but not: " + query);
        }
        String collectionName = (String)this.collectionNameExpression.getValue((EvaluationContext)this.evaluationContext, String.class);
        Assert.notNull((Object)collectionName, (String)"'collectionNameExpression' must not evaluate to null");
        Object result = this.expectSingleResult ? this.reactiveMongoTemplate.findOne((Query)query, this.entityClass, collectionName) : this.reactiveMongoTemplate.find((Query)query, this.entityClass, collectionName);
        return this.getMessageBuilderFactory().withPayload(result).setHeader("mongo_collectionName", (Object)collectionName);
    }
}

