/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteOperation;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.message.AdviceMessage;
import org.springframework.integration.mongodb.store.ConfigurableMongoDbMessageStore;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.support.MutableMessageBuilder;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoDbMessageStore
extends AbstractMessageGroupStore
implements MessageStore,
BeanClassLoaderAware,
ApplicationContextAware,
InitializingBean {
    private static final String DEFAULT_COLLECTION_NAME = "messages";
    public static final String SEQUENCE_NAME = "messagesSequence";
    public static final String SAVED_KEY = ConfigurableMongoDbMessageStore.class.getSimpleName() + ".SAVED";
    public static final String CREATED_DATE_KEY = ConfigurableMongoDbMessageStore.class.getSimpleName() + ".CREATED_DATE";
    private static final String GROUP_ID_KEY = "_groupId";
    private static final String GROUP_COMPLETE_KEY = "_group_complete";
    private static final String LAST_RELEASED_SEQUENCE_NUMBER = "_last_released_sequence";
    private static final String GROUP_TIMESTAMP_KEY = "_group_timestamp";
    private static final String GROUP_UPDATE_TIMESTAMP_KEY = "_group_update_timestamp";
    private static final String CREATED_DATE = "_createdDate";
    private static final String SEQUENCE = "sequence";
    private final MongoTemplate template;
    private final MessageReadingMongoConverter converter;
    private final String collectionName;
    private volatile ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private ApplicationContext applicationContext;

    public MongoDbMessageStore(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null);
    }

    public MongoDbMessageStore(MongoDbFactory mongoDbFactory, String collectionName) {
        Assert.notNull((Object)mongoDbFactory, (String)"mongoDbFactory must not be null");
        this.converter = new MessageReadingMongoConverter(mongoDbFactory, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)new MongoMappingContext());
        this.template = new MongoTemplate(mongoDbFactory, (MongoConverter)this.converter);
        this.collectionName = StringUtils.hasText((String)collectionName) ? collectionName : DEFAULT_COLLECTION_NAME;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"classLoader must not be null");
        this.classLoader = classLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationContext != null) {
            this.template.setApplicationContext(this.applicationContext);
            this.converter.setApplicationContext(this.applicationContext);
        }
        this.converter.afterPropertiesSet();
        IndexOperations indexOperations = this.template.indexOps(this.collectionName);
        indexOperations.ensureIndex((IndexDefinition)new Index(GROUP_ID_KEY, Sort.Direction.ASC).on(GROUP_UPDATE_TIMESTAMP_KEY, Sort.Direction.DESC).on(SEQUENCE, Sort.Direction.DESC));
    }

    public <T> Message<T> addMessage(Message<T> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        this.addMessageDocument(new MessageWrapper(message));
        return message;
    }

    private void addMessageDocument(MessageWrapper document) {
        Message<?> saved;
        Message<?> message = document.getMessage();
        if (message.getHeaders().containsKey((Object)SAVED_KEY) && (saved = this.getMessage(message.getHeaders().getId())) != null && saved.equals(message)) {
            return;
        }
        long createdDate = document.get_Group_timestamp() == 0L ? System.currentTimeMillis() : document.get_Group_timestamp();
        Message result = this.getMessageBuilderFactory().fromMessage(message).setHeader(SAVED_KEY, (Object)Boolean.TRUE).setHeader(CREATED_DATE_KEY, (Object)createdDate).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)result.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().get((Object)"id"));
        innerMap.put("timestamp", message.getHeaders().get((Object)"timestamp"));
        document.set_Group_timestamp(createdDate);
        this.template.insert((Object)document, this.collectionName);
    }

    public Message<?> getMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findOne(MongoDbMessageStore.whereMessageIdIs(id), MessageWrapper.class, this.collectionName);
        return messageWrapper != null ? messageWrapper.getMessage() : null;
    }

    @ManagedAttribute
    public long getMessageCount() {
        return this.template.getCollection(this.collectionName).getCount();
    }

    public Message<?> removeMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findAndRemove(MongoDbMessageStore.whereMessageIdIs(id), MessageWrapper.class, this.collectionName);
        return messageWrapper != null ? messageWrapper.getMessage() : null;
    }

    public MessageGroup getMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Query query = MongoDbMessageStore.whereGroupIdOrder(groupId);
        List messageWrappers = this.template.find(query, MessageWrapper.class, this.collectionName);
        ArrayList messages = new ArrayList();
        long timestamp = 0L;
        long lastModified = 0L;
        int lastReleasedSequenceNumber = 0;
        boolean completeGroup = false;
        if (messageWrappers.size() > 0) {
            MessageWrapper messageWrapper = (MessageWrapper)messageWrappers.get(0);
            timestamp = messageWrapper.get_Group_timestamp();
            lastModified = messageWrapper.get_Group_update_timestamp();
            completeGroup = messageWrapper.get_Group_complete();
            lastReleasedSequenceNumber = messageWrapper.get_LastReleasedSequenceNumber();
        }
        for (MessageWrapper messageWrapper : messageWrappers) {
            messages.add(messageWrapper.getMessage());
        }
        SimpleMessageGroup messageGroup = new SimpleMessageGroup(messages, groupId, timestamp, completeGroup);
        messageGroup.setLastModified(lastModified);
        if (lastReleasedSequenceNumber > 0) {
            messageGroup.setLastReleasedMessageSequenceNumber(lastReleasedSequenceNumber);
        }
        return messageGroup;
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(message, (String)"'message' must not be null");
        Query query = MongoDbMessageStore.whereGroupIdOrder(groupId);
        MessageWrapper messageDocument = (MessageWrapper)this.template.findOne(query, MessageWrapper.class, this.collectionName);
        long createdTime = System.currentTimeMillis();
        int lastReleasedSequence = 0;
        boolean complete = false;
        if (messageDocument != null) {
            createdTime = messageDocument.get_Group_timestamp();
            lastReleasedSequence = messageDocument.get_LastReleasedSequenceNumber();
            complete = messageDocument.get_Group_complete();
        }
        MessageWrapper wrapper = new MessageWrapper(message);
        wrapper.set_GroupId(groupId);
        wrapper.set_Group_timestamp(createdTime);
        wrapper.set_Group_update_timestamp(messageDocument == null ? createdTime : System.currentTimeMillis());
        wrapper.set_Group_complete(complete);
        wrapper.set_LastReleasedSequenceNumber(lastReleasedSequence);
        wrapper.setSequence(this.getNextId());
        this.addMessageDocument(wrapper);
        return this.getMessageGroup(groupId);
    }

    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messageToRemove, (String)"'messageToRemove' must not be null");
        this.template.findAndRemove(MongoDbMessageStore.whereMessageIdIsAndGroupIdIs(messageToRemove.getHeaders().getId(), groupId), MessageWrapper.class, this.collectionName);
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate());
        return this.getMessageGroup(groupId);
    }

    public void removeMessagesFromGroup(Object groupId, Collection<Message<?>> messages) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messages, (String)"'messageToRemove' must not be null");
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (Message<?> messageToRemove : messages) {
            ids.add(messageToRemove.getHeaders().getId());
            if (ids.size() < this.getRemoveBatchSize()) continue;
            this.bulkRemove(groupId, ids);
            ids.clear();
        }
        if (ids.size() > 0) {
            this.bulkRemove(groupId, ids);
        }
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate());
    }

    private void bulkRemove(Object groupId, Collection<UUID> ids) {
        BulkWriteOperation bulkOp = this.template.getCollection(this.collectionName).initializeOrderedBulkOperation();
        for (UUID id : ids) {
            bulkOp.find(MongoDbMessageStore.whereMessageIdIsAndGroupIdIs(id, groupId).getQueryObject()).remove();
        }
        bulkOp.execute();
    }

    public void removeMessageGroup(Object groupId) {
        this.template.remove(MongoDbMessageStore.whereGroupIdIs(groupId), this.collectionName);
    }

    public Iterator<MessageGroup> iterator() {
        ArrayList<MessageGroup> messageGroups = new ArrayList<MessageGroup>();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)GROUP_ID_KEY).exists(true));
        List groupIds = this.template.getCollection(this.collectionName).distinct(GROUP_ID_KEY, query.getQueryObject());
        for (Object groupId : groupIds) {
            messageGroups.add(this.getMessageGroup(groupId));
        }
        return messageGroups.iterator();
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Query query = MongoDbMessageStore.whereGroupIdIs(groupId).with(new Sort(new String[]{GROUP_UPDATE_TIMESTAMP_KEY, SEQUENCE}));
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findAndRemove(query, MessageWrapper.class, this.collectionName);
        Message<?> message = null;
        if (messageWrapper != null) {
            message = messageWrapper.getMessage();
        }
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate());
        return message;
    }

    public int messageGroupSize(Object groupId) {
        long lCount = this.template.count(new Query((CriteriaDefinition)Criteria.where((String)GROUP_ID_KEY).is(groupId)), this.collectionName);
        Assert.isTrue((lCount <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)lCount;
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate().set(LAST_RELEASED_SEQUENCE_NUMBER, (Object)sequenceNumber));
    }

    public void completeGroup(Object groupId) {
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate().set(GROUP_COMPLETE_KEY, (Object)true));
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").exists(true).and("groupId").exists(true));
        long count = this.template.count(query, this.collectionName);
        Assert.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)count;
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"groupId").exists(true));
        return this.template.getCollection(this.collectionName).distinct("groupId", query.getQueryObject()).size();
    }

    private static Update lastModifiedUpdate() {
        return Update.update((String)GROUP_UPDATE_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
    }

    private static Query whereMessageIdIs(UUID id) {
        return new Query((CriteriaDefinition)Criteria.where((String)"headers.id._value").is((Object)id.toString()));
    }

    private static Query whereMessageIdIsAndGroupIdIs(UUID id, Object groupId) {
        return new Query((CriteriaDefinition)Criteria.where((String)"headers.id._value").is((Object)id.toString()).and(GROUP_ID_KEY).is(groupId));
    }

    private static Query whereGroupIdOrder(Object groupId) {
        return MongoDbMessageStore.whereGroupIdIs(groupId).with(new Sort(Sort.Direction.DESC, new String[]{GROUP_UPDATE_TIMESTAMP_KEY, SEQUENCE}));
    }

    private static Query whereGroupIdIs(Object groupId) {
        return new Query((CriteriaDefinition)Criteria.where((String)GROUP_ID_KEY).is(groupId));
    }

    private void updateGroup(Object groupId, Update update) {
        Query query = MongoDbMessageStore.whereGroupIdIs(groupId).with(new Sort(Sort.Direction.DESC, new String[]{GROUP_UPDATE_TIMESTAMP_KEY, SEQUENCE}));
        this.template.updateFirst(query, update, this.collectionName);
    }

    private int getNextId() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)SEQUENCE_NAME));
        query.fields().include(SEQUENCE);
        return (Integer)((Map)this.template.findAndModify(query, new Update().inc(SEQUENCE, (Number)1), FindAndModifyOptions.options().returnNew(true).upsert(true), Map.class, this.collectionName)).get(SEQUENCE);
    }

    private static void enhanceHeaders(MessageHeaders messageHeaders, Map<String, Object> headers) {
        Map innerMap = (Map)new DirectFieldAccessor((Object)messageHeaders).getPropertyValue("headers");
        innerMap.put("id", headers.get("id"));
        innerMap.put("timestamp", headers.get("timestamp"));
    }

    private static final class MessageWrapper {
        @Id
        private String _id;
        private volatile Object _groupId;
        @Transient
        private final Message<?> message;
        private final String _messageType;
        private final Object payload;
        private final Map<String, ?> headers;
        private final Message<?> inputMessage;
        private volatile long _group_timestamp;
        private volatile long _group_update_timestamp;
        private volatile int _last_released_sequence;
        private volatile boolean _group_complete;
        private int sequence;

        public MessageWrapper(Message<?> message) {
            Assert.notNull(message, (String)"'message' must not be null");
            this.message = message;
            this._messageType = message.getClass().getName();
            this.payload = message.getPayload();
            this.headers = message.getHeaders();
            this.inputMessage = message instanceof AdviceMessage ? ((AdviceMessage)message).getInputMessage() : null;
        }

        public int get_LastReleasedSequenceNumber() {
            return this._last_released_sequence;
        }

        public long get_Group_timestamp() {
            return this._group_timestamp;
        }

        public boolean get_Group_complete() {
            return this._group_complete;
        }

        public Object get_GroupId() {
            return this._groupId;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public void set_GroupId(Object groupId) {
            this._groupId = groupId;
        }

        public void set_Group_timestamp(long groupTimestamp) {
            this._group_timestamp = groupTimestamp;
        }

        public long get_Group_update_timestamp() {
            return this._group_update_timestamp;
        }

        public void set_Group_update_timestamp(long lastModified) {
            this._group_update_timestamp = lastModified;
        }

        public void set_LastReleasedSequenceNumber(int lastReleasedSequenceNumber) {
            this._last_released_sequence = lastReleasedSequenceNumber;
        }

        public void set_Group_complete(boolean completedGroup) {
            this._group_complete = completedGroup;
        }

        public void setSequence(int sequence) {
            this.sequence = sequence;
        }
    }

    @WritingConverter
    private class ThrowableToBytesConverter
    implements Converter<Throwable, byte[]> {
        private final Converter<Object, byte[]> serializingConverter = new SerializingConverter();

        private ThrowableToBytesConverter() {
        }

        public byte[] convert(Throwable source) {
            return (byte[])this.serializingConverter.convert((Object)source);
        }
    }

    private class DBObjectToErrorMessageConverter
    implements Converter<DBObject, ErrorMessage> {
        private final Converter<byte[], Object> deserializingConverter = new DeserializingConverter();

        private DBObjectToErrorMessageConverter() {
        }

        public ErrorMessage convert(DBObject source) {
            Map headers = MongoDbMessageStore.this.converter.normalizeHeaders((Map)source.get("headers"));
            Object payload = this.deserializingConverter.convert((Object)((byte[])source.get("payload")));
            ErrorMessage message = new ErrorMessage((Throwable)payload, headers);
            MongoDbMessageStore.enhanceHeaders(message.getHeaders(), headers);
            return message;
        }
    }

    private class DBObjectToAdviceMessageConverter
    implements Converter<DBObject, AdviceMessage> {
        private DBObjectToAdviceMessageConverter() {
        }

        public AdviceMessage convert(DBObject source) {
            Map headers = MongoDbMessageStore.this.converter.normalizeHeaders((Map)source.get("headers"));
            Message inputMessage = null;
            if (source.get("inputMessage") != null) {
                DBObject inputMessageObject = (DBObject)source.get("inputMessage");
                Object inputMessageType = inputMessageObject.get("_class");
                try {
                    Class messageClass = ClassUtils.forName((String)inputMessageType.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader);
                    inputMessage = (Message)MongoDbMessageStore.this.converter.read(messageClass, inputMessageObject);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to load class: " + inputMessageType, e);
                }
            }
            AdviceMessage message = new AdviceMessage(MongoDbMessageStore.this.converter.extractPayload(source), headers, inputMessage);
            MongoDbMessageStore.enhanceHeaders(message.getHeaders(), headers);
            return message;
        }
    }

    private class DBObjectToMutableMessageConverter
    implements GenericConverter {
        private final Class<?> mutableMessageClass;

        private DBObjectToMutableMessageConverter() {
            try {
                this.mutableMessageClass = ClassUtils.forName((String)"org.springframework.integration.support.MutableMessage", (ClassLoader)MongoDbMessageStore.this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            HashSet<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
            convertiblePairs.add(new GenericConverter.ConvertiblePair(DBObject.class, this.mutableMessageClass));
            return convertiblePairs;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            DBObject dbObject = (DBObject)source;
            Map headers = MongoDbMessageStore.this.converter.normalizeHeaders((Map)dbObject.get("headers"));
            return MutableMessageBuilder.withPayload((Object)MongoDbMessageStore.this.converter.extractPayload(dbObject)).copyHeaders(headers).build();
        }
    }

    private class DBObjectToGenericMessageConverter
    implements Converter<DBObject, GenericMessage<?>> {
        private DBObjectToGenericMessageConverter() {
        }

        public GenericMessage<?> convert(DBObject source) {
            Map headers = MongoDbMessageStore.this.converter.normalizeHeaders((Map)source.get("headers"));
            GenericMessage message = new GenericMessage(MongoDbMessageStore.this.converter.extractPayload(source), headers);
            MongoDbMessageStore.enhanceHeaders(message.getHeaders(), headers);
            return message;
        }
    }

    private static class MessageHistoryToDBObjectConverter
    implements Converter<MessageHistory, DBObject> {
        private MessageHistoryToDBObjectConverter() {
        }

        public DBObject convert(MessageHistory source) {
            BasicDBObject obj = new BasicDBObject();
            obj.put("_class", (Object)MessageHistory.class.getName());
            BasicDBList dbList = new BasicDBList();
            for (Properties properties : source) {
                BasicDBObject dbo = new BasicDBObject();
                dbo.put("name", (Object)properties.getProperty("name"));
                dbo.put("type", (Object)properties.getProperty("type"));
                dbo.put("timestamp", (Object)properties.getProperty("timestamp"));
                dbList.add((Object)dbo);
            }
            obj.put("components", (Object)dbList);
            return obj;
        }
    }

    private static class DBObjectToUUIDConverter
    implements Converter<DBObject, UUID> {
        private DBObjectToUUIDConverter() {
        }

        public UUID convert(DBObject source) {
            return UUID.fromString((String)source.get("_value"));
        }
    }

    private static class UuidToDBObjectConverter
    implements Converter<UUID, DBObject> {
        private UuidToDBObjectConverter() {
        }

        public DBObject convert(UUID source) {
            BasicDBObject dbObject = new BasicDBObject();
            dbObject.put("_value", (Object)source.toString());
            dbObject.put("_class", (Object)source.getClass().getName());
            return dbObject;
        }
    }

    private class MessageReadingMongoConverter
    extends MappingMongoConverter {
        public MessageReadingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            super((DbRefResolver)new DefaultDbRefResolver(mongoDbFactory), mappingContext);
        }

        public void afterPropertiesSet() {
            ArrayList<Object> customConverters = new ArrayList<Object>();
            customConverters.add(new UuidToDBObjectConverter());
            customConverters.add(new DBObjectToUUIDConverter());
            customConverters.add(new MessageHistoryToDBObjectConverter());
            customConverters.add(new DBObjectToGenericMessageConverter());
            customConverters.add(new DBObjectToMutableMessageConverter());
            customConverters.add(new DBObjectToErrorMessageConverter());
            customConverters.add(new DBObjectToAdviceMessageConverter());
            customConverters.add(new ThrowableToBytesConverter());
            this.setCustomConversions(new CustomConversions(customConverters));
            super.afterPropertiesSet();
        }

        public void write(Object source, DBObject target) {
            Assert.isInstanceOf(MessageWrapper.class, (Object)source);
            target.put(MongoDbMessageStore.CREATED_DATE, (Object)System.currentTimeMillis());
            super.write(source, target);
        }

        public <S> S read(Class<S> clazz, DBObject source) {
            if (!MessageWrapper.class.equals(clazz)) {
                return (S)super.read(clazz, source);
            }
            if (source != null) {
                Message message = null;
                Object messageType = source.get("_messageType");
                if (messageType == null) {
                    messageType = GenericMessage.class.getName();
                }
                try {
                    message = (Message)this.read(ClassUtils.forName((String)messageType.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader), source);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("failed to load class: " + messageType, e);
                }
                Long groupTimestamp = (Long)source.get(MongoDbMessageStore.GROUP_TIMESTAMP_KEY);
                Long lastModified = (Long)source.get(MongoDbMessageStore.GROUP_UPDATE_TIMESTAMP_KEY);
                Integer lastReleasedSequenceNumber = (Integer)source.get(MongoDbMessageStore.LAST_RELEASED_SEQUENCE_NUMBER);
                Boolean completeGroup = (Boolean)source.get(MongoDbMessageStore.GROUP_COMPLETE_KEY);
                MessageWrapper wrapper = new MessageWrapper(message);
                if (source.containsField(MongoDbMessageStore.GROUP_ID_KEY)) {
                    wrapper.set_GroupId(source.get(MongoDbMessageStore.GROUP_ID_KEY));
                }
                if (groupTimestamp != null) {
                    wrapper.set_Group_timestamp(groupTimestamp);
                }
                if (lastModified != null) {
                    wrapper.set_Group_update_timestamp(lastModified);
                }
                if (lastReleasedSequenceNumber != null) {
                    wrapper.set_LastReleasedSequenceNumber(lastReleasedSequenceNumber);
                }
                if (completeGroup != null) {
                    wrapper.set_Group_complete(completeGroup);
                }
                return (S)wrapper;
            }
            return null;
        }

        private Map<String, Object> normalizeHeaders(Map<String, Object> headers) {
            HashMap<String, Object> normalizedHeaders = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                String headerName = entry.getKey();
                Object headerValue = entry.getValue();
                if (headerValue instanceof DBObject) {
                    DBObject source = (DBObject)headerValue;
                    try {
                        Class typeClass = null;
                        if (source.containsField("_class")) {
                            Object type = source.get("_class");
                            typeClass = ClassUtils.forName((String)type.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader);
                        } else if (source instanceof BasicDBList) {
                            typeClass = List.class;
                        } else {
                            throw new IllegalStateException("Unsupported 'DBObject' type: " + source.getClass());
                        }
                        normalizedHeaders.put(headerName, super.read(typeClass, source));
                    }
                    catch (Exception e) {
                        MongoDbMessageStore.this.logger.warn((Object)("Header '" + headerName + "' could not be deserialized."), (Throwable)e);
                    }
                    continue;
                }
                normalizedHeaders.put(headerName, headerValue);
            }
            return normalizedHeaders;
        }

        private Object extractPayload(DBObject source) {
            Object payload = source.get("payload");
            if (payload instanceof DBObject) {
                DBObject payloadObject = (DBObject)payload;
                Object payloadType = payloadObject.get("_class");
                try {
                    Class payloadClass = ClassUtils.forName((String)payloadType.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader);
                    payload = this.read(payloadClass, payloadObject);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to load class: " + payloadType, e);
                }
            }
            return payload;
        }
    }
}

