/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.integration.Message;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDbMessageStore
extends AbstractMessageGroupStore
implements MessageStore,
BeanClassLoaderAware {
    private static final String DEFAULT_COLLECTION_NAME = "messages";
    private static final String GROUP_ID_KEY = "_groupId";
    private static final String GROUP_COMPLETE_KEY = "_group_complete";
    private static final String LAST_RELEASED_SEQUENCE_NUMBER = "_last_released_sequence";
    private static final String GROUP_TIMESTAMP_KEY = "_group_timestamp";
    private static final String GROUP_UPDATE_TIMESTAMP_KEY = "_group_update_timestamp";
    private static final String PAYLOAD_TYPE_KEY = "_payloadType";
    private static final String CREATED_DATE = "_createdDate";
    private final MongoTemplate template;
    private final String collectionName;
    private volatile ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public MongoDbMessageStore(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null);
    }

    public MongoDbMessageStore(MongoDbFactory mongoDbFactory, String collectionName) {
        Assert.notNull((Object)mongoDbFactory, (String)"mongoDbFactory must not be null");
        MessageReadingMongoConverter converter = new MessageReadingMongoConverter(mongoDbFactory, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)new MongoMappingContext());
        converter.afterPropertiesSet();
        this.template = new MongoTemplate(mongoDbFactory, (MongoConverter)converter);
        this.collectionName = StringUtils.hasText((String)collectionName) ? collectionName : DEFAULT_COLLECTION_NAME;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"classLoader must not be null");
        this.classLoader = classLoader;
    }

    public <T> Message<T> addMessage(Message<T> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        this.template.insert((Object)new MessageWrapper(message), this.collectionName);
        return message;
    }

    public Message<?> getMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findOne(MongoDbMessageStore.whereMessageIdIs(id), MessageWrapper.class, this.collectionName);
        return messageWrapper != null ? messageWrapper.getMessage() : null;
    }

    @ManagedAttribute
    public long getMessageCount() {
        return this.template.getCollection(this.collectionName).getCount();
    }

    public Message<?> removeMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findAndRemove(MongoDbMessageStore.whereMessageIdIs(id), MessageWrapper.class, this.collectionName);
        return messageWrapper != null ? messageWrapper.getMessage() : null;
    }

    public MessageGroup getMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        List messageWrappers = this.template.find(MongoDbMessageStore.whereGroupIdIs(groupId), MessageWrapper.class, this.collectionName);
        ArrayList messages = new ArrayList();
        long timestamp = 0L;
        long lastmodified = 0L;
        int lastReleasedSequenceNumber = 0;
        boolean completeGroup = false;
        if (messageWrappers.size() > 0) {
            MessageWrapper messageWrapper = (MessageWrapper)messageWrappers.get(0);
            timestamp = messageWrapper.get_Group_timestamp();
            lastmodified = messageWrapper.get_Group_update_timestamp();
            completeGroup = messageWrapper.get_Group_complete();
            lastReleasedSequenceNumber = messageWrapper.get_LastReleasedSequenceNumber();
        }
        for (MessageWrapper messageWrapper : messageWrappers) {
            messages.add(messageWrapper.getMessage());
        }
        SimpleMessageGroup messageGroup = new SimpleMessageGroup(messages, groupId, timestamp, completeGroup);
        messageGroup.setLastModified(lastmodified);
        if (lastReleasedSequenceNumber > 0) {
            messageGroup.setLastReleasedMessageSequenceNumber(lastReleasedSequenceNumber);
        }
        return messageGroup;
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(message, (String)"'message' must not be null");
        MessageGroup messageGroup = this.getMessageGroup(groupId);
        long messageGroupTimestamp = messageGroup.getTimestamp();
        long lastModified = messageGroup.getLastModified();
        lastModified = messageGroupTimestamp == 0L ? (messageGroupTimestamp = System.currentTimeMillis()) : System.currentTimeMillis();
        MessageWrapper wrapper = new MessageWrapper(message);
        wrapper.set_GroupId(groupId);
        wrapper.set_Group_timestamp(messageGroupTimestamp);
        wrapper.set_Group_update_timestamp(lastModified);
        wrapper.set_Group_complete(messageGroup.isComplete());
        wrapper.set_LastReleasedSequenceNumber(messageGroup.getLastReleasedMessageSequenceNumber());
        this.template.insert((Object)wrapper, this.collectionName);
        return this.getMessageGroup(groupId);
    }

    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messageToRemove, (String)"'messageToRemove' must not be null");
        this.removeMessage(messageToRemove.getHeaders().getId());
        this.updateGroup(groupId);
        return this.getMessageGroup(groupId);
    }

    public void removeMessageGroup(Object groupId) {
        List messageWrappers = this.template.find(MongoDbMessageStore.whereGroupIdIs(groupId), MessageWrapper.class, this.collectionName);
        for (MessageWrapper messageWrapper : messageWrappers) {
            this.removeMessageFromGroup(groupId, messageWrapper.getMessage());
        }
    }

    public Iterator<MessageGroup> iterator() {
        List groupedMessages = this.template.find(MongoDbMessageStore.whereGroupIdExists(), MessageWrapper.class, this.collectionName);
        HashMap<Object, MessageGroup> messageGroups = new HashMap<Object, MessageGroup>();
        for (MessageWrapper groupedMessage : groupedMessages) {
            Object groupId = groupedMessage.get_GroupId();
            if (messageGroups.containsKey(groupId)) continue;
            messageGroups.put(groupId, this.getMessageGroup(groupId));
        }
        return messageGroups.values().iterator();
    }

    public void completeGroup(Object groupId) {
        Update update = Update.update((String)GROUP_COMPLETE_KEY, (Object)true);
        Query q = MongoDbMessageStore.whereGroupIdIs(groupId);
        this.template.updateFirst(q, update, this.collectionName);
        this.updateGroup(groupId);
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        Update update = Update.update((String)LAST_RELEASED_SEQUENCE_NUMBER, (Object)sequenceNumber);
        Query q = MongoDbMessageStore.whereGroupIdIs(groupId);
        this.template.updateFirst(q, update, this.collectionName);
        this.updateGroup(groupId);
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        List messageWrappers = this.template.find(MongoDbMessageStore.whereGroupIdIsOrdered(groupId), MessageWrapper.class, this.collectionName);
        Message<?> message = null;
        if (!CollectionUtils.isEmpty((Collection)messageWrappers)) {
            message = ((MessageWrapper)messageWrappers.get(0)).getMessage();
            this.removeMessageFromGroup(groupId, message);
        }
        this.updateGroup(groupId);
        return message;
    }

    public int messageGroupSize(Object groupId) {
        long lCount = this.template.count(new Query(Criteria.where((String)GROUP_ID_KEY).is(groupId)), this.collectionName);
        Assert.isTrue((lCount <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)lCount;
    }

    private static Query whereMessageIdIs(UUID id) {
        return new Query(Criteria.where((String)"headers.id._value").is((Object)id.toString()));
    }

    private static Query whereGroupIdIs(Object groupId) {
        Query q = new Query(Criteria.where((String)GROUP_ID_KEY).is(groupId));
        q.with(new Sort(Sort.Direction.DESC, new String[]{GROUP_UPDATE_TIMESTAMP_KEY}));
        return q;
    }

    private static Query whereGroupIdExists() {
        return new Query(Criteria.where((String)GROUP_ID_KEY).exists(true));
    }

    private static Query whereGroupIdIsOrdered(Object groupId) {
        Query q = new Query(Criteria.where((String)GROUP_ID_KEY).is(groupId)).limit(1);
        q.with(new Sort(Sort.Direction.ASC, new String[]{CREATED_DATE}));
        return q;
    }

    private void updateGroup(Object groupId) {
        Update update = Update.update((String)GROUP_UPDATE_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
        Query q = MongoDbMessageStore.whereGroupIdIs(groupId);
        this.template.updateFirst(q, update, this.collectionName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MessageWrapper {
        private volatile Object _groupId;
        @Transient
        private final Message<?> message;
        private final Object payload;
        private final Map<String, ?> headers;
        private final String _payloadType;
        private volatile long _group_timestamp;
        private volatile long _group_update_timestamp;
        private volatile int _last_released_sequence;
        private volatile boolean _group_complete;

        public MessageWrapper(Message<?> message) {
            Assert.notNull(message, (String)"'message' must not be null");
            this.message = message;
            this.payload = message.getPayload();
            this.headers = message.getHeaders();
            this._payloadType = this.payload.getClass().getName();
        }

        public int get_LastReleasedSequenceNumber() {
            return this._last_released_sequence;
        }

        public long get_Group_timestamp() {
            return this._group_timestamp;
        }

        public boolean get_Group_complete() {
            return this._group_complete;
        }

        public Object get_GroupId() {
            return this._groupId;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public void set_GroupId(Object groupId) {
            this._groupId = groupId;
        }

        public void set_Group_timestamp(long groupTimestamp) {
            this._group_timestamp = groupTimestamp;
        }

        public long get_Group_update_timestamp() {
            return this._group_update_timestamp;
        }

        public void set_Group_update_timestamp(long lastModified) {
            this._group_update_timestamp = lastModified;
        }

        public void set_LastReleasedSequenceNumber(int lastReleasedSequenceNumber) {
            this._last_released_sequence = lastReleasedSequenceNumber;
        }

        public void set_Group_complete(boolean completedGroup) {
            this._group_complete = completedGroup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageHistoryToDBObjectConverter
    implements Converter<MessageHistory, DBObject> {
        private MessageHistoryToDBObjectConverter() {
        }

        public DBObject convert(MessageHistory source) {
            BasicDBObject obj = new BasicDBObject();
            obj.put("_class", (Object)MessageHistory.class.getName());
            BasicDBList dbList = new BasicDBList();
            for (Properties properties : source) {
                BasicDBObject dbo = new BasicDBObject();
                dbo.put("name", (Object)properties.getProperty("name"));
                dbo.put("type", (Object)properties.getProperty("type"));
                dbo.put("timestamp", (Object)properties.getProperty("timestamp"));
                dbList.add((Object)dbo);
            }
            obj.put("components", (Object)dbList);
            return obj;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DBObjectToUUIDConverter
    implements Converter<DBObject, UUID> {
        private DBObjectToUUIDConverter() {
        }

        public UUID convert(DBObject source) {
            UUID id = UUID.fromString((String)source.get("_value"));
            return id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UuidToDBObjectConverter
    implements Converter<UUID, DBObject> {
        private UuidToDBObjectConverter() {
        }

        public DBObject convert(UUID source) {
            BasicDBObject dbObject = new BasicDBObject();
            dbObject.put("_value", (Object)source.toString());
            dbObject.put("_class", (Object)source.getClass().getName());
            return dbObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageReadingMongoConverter
    extends MappingMongoConverter {
        public MessageReadingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            super(mongoDbFactory, mappingContext);
        }

        public void afterPropertiesSet() {
            ArrayList<Object> customConverters = new ArrayList<Object>();
            customConverters.add(new UuidToDBObjectConverter());
            customConverters.add(new DBObjectToUUIDConverter());
            customConverters.add(new MessageHistoryToDBObjectConverter());
            this.setCustomConversions(new CustomConversions(customConverters));
            super.afterPropertiesSet();
        }

        public void write(Object source, DBObject target) {
            Assert.isInstanceOf(MessageWrapper.class, (Object)source);
            target.put(MongoDbMessageStore.CREATED_DATE, (Object)System.currentTimeMillis());
            super.write(source, target);
        }

        public <S> S read(Class<S> clazz, DBObject source) {
            if (!MessageWrapper.class.equals(clazz)) {
                return (S)super.read(clazz, source);
            }
            if (source != null) {
                Map<String, Object> headers = this.normalizeHeaders((Map)source.get("headers"));
                Object payload = source.get("payload");
                Object payloadType = source.get(MongoDbMessageStore.PAYLOAD_TYPE_KEY);
                if (payloadType != null && payload instanceof DBObject) {
                    try {
                        Class payloadClass = ClassUtils.forName((String)payloadType.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader);
                        payload = this.read(payloadClass, (DBObject)payload);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("failed to load class: " + payloadType, e);
                    }
                }
                GenericMessage message = new GenericMessage(payload, headers);
                Map innerMap = (Map)new DirectFieldAccessor((Object)message.getHeaders()).getPropertyValue("headers");
                innerMap.put("id", headers.get("id"));
                innerMap.put("timestamp", headers.get("timestamp"));
                Long groupTimestamp = (Long)source.get(MongoDbMessageStore.GROUP_TIMESTAMP_KEY);
                Long lastModified = (Long)source.get(MongoDbMessageStore.GROUP_UPDATE_TIMESTAMP_KEY);
                Integer lastReleasedSequenceNumber = (Integer)source.get(MongoDbMessageStore.LAST_RELEASED_SEQUENCE_NUMBER);
                Boolean completeGroup = (Boolean)source.get(MongoDbMessageStore.GROUP_COMPLETE_KEY);
                MessageWrapper wrapper = new MessageWrapper((Message<?>)message);
                if (source.containsField(MongoDbMessageStore.GROUP_ID_KEY)) {
                    wrapper.set_GroupId(source.get(MongoDbMessageStore.GROUP_ID_KEY));
                }
                if (groupTimestamp != null) {
                    wrapper.set_Group_timestamp(groupTimestamp);
                }
                if (lastModified != null) {
                    wrapper.set_Group_update_timestamp(lastModified);
                }
                if (lastReleasedSequenceNumber != null) {
                    wrapper.set_LastReleasedSequenceNumber(lastReleasedSequenceNumber);
                }
                if (completeGroup != null) {
                    wrapper.set_Group_complete(completeGroup);
                }
                return (S)wrapper;
            }
            return null;
        }

        private Map<String, Object> normalizeHeaders(Map<String, Object> headers) {
            HashMap<String, Object> normalizedHeaders = new HashMap<String, Object>();
            for (String headerName : headers.keySet()) {
                Object headerValue = headers.get(headerName);
                if (headerValue instanceof DBObject) {
                    DBObject source = (DBObject)headerValue;
                    Object type = source.get("_class");
                    try {
                        Class typeClass = ClassUtils.forName((String)type.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader);
                        normalizedHeaders.put(headerName, super.read(typeClass, source));
                    }
                    catch (Exception e) {
                        MongoDbMessageStore.this.logger.warn((Object)("Header '" + headerName + "' could not be deserialized."), (Throwable)e);
                    }
                    continue;
                }
                normalizedHeaders.put(headerName, headerValue);
            }
            return normalizedHeaders;
        }
    }
}

