/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.dsl;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.aopalliance.aop.Advice;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageProducerSpec;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.mail.ImapIdleChannelAdapter;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.SearchTermStrategy;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.PropertiesBuilder;
import org.springframework.integration.transaction.TransactionInterceptorBuilder;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public class ImapIdleChannelAdapterSpec
extends MessageProducerSpec<ImapIdleChannelAdapterSpec, ImapIdleChannelAdapter>
implements ComponentsRegistration {
    protected final ImapMailReceiver receiver;
    protected final Map<Object, String> componentsToRegister = new LinkedHashMap<Object, String>();
    private final List<Advice> adviceChain = new LinkedList<Advice>();
    protected final boolean externalReceiver;
    private boolean sessionProvided;

    protected ImapIdleChannelAdapterSpec(ImapMailReceiver receiver) {
        this(receiver, false);
    }

    protected ImapIdleChannelAdapterSpec(ImapMailReceiver receiver, boolean externalReceiver) {
        super((MessageProducerSupport)new ImapIdleChannelAdapter(receiver));
        ((ImapIdleChannelAdapter)((Object)this.target)).setAdviceChain(this.adviceChain);
        this.receiver = receiver;
        this.componentsToRegister.put(receiver, receiver.getComponentName());
        this.externalReceiver = externalReceiver;
    }

    public ImapIdleChannelAdapterSpec selectorExpression(String selectorExpression) {
        return this.selectorExpression(PARSER.parseExpression(selectorExpression));
    }

    public ImapIdleChannelAdapterSpec selectorExpression(Expression selectorExpression) {
        this.assertReceiver();
        this.receiver.setSelectorExpression(selectorExpression);
        return this;
    }

    private void assertReceiver() {
        Assert.state((!this.externalReceiver ? 1 : 0) != 0, () -> "An external 'receiver' [" + this.receiver + "] can't be modified.");
    }

    public ImapIdleChannelAdapterSpec selector(Function<MimeMessage, Boolean> selectorFunction) {
        return this.selectorExpression((Expression)new FunctionExpression(selectorFunction));
    }

    public ImapIdleChannelAdapterSpec session(Session session) {
        this.assertReceiver();
        this.receiver.setSession(session);
        this.sessionProvided = true;
        return this;
    }

    public ImapIdleChannelAdapterSpec javaMailProperties(Properties javaMailProperties) {
        this.assertReceiver();
        this.assertSession();
        this.receiver.setJavaMailProperties(javaMailProperties);
        return this;
    }

    private void assertSession() {
        Assert.state((!this.sessionProvided ? 1 : 0) != 0, (String)"Neither 'javaMailProperties' nor 'javaMailAuthenticator' references are allowed when a 'session' reference has been provided.");
    }

    public ImapIdleChannelAdapterSpec javaMailProperties(Consumer<PropertiesBuilder> configurer) {
        PropertiesBuilder properties = new PropertiesBuilder();
        configurer.accept(properties);
        return this.javaMailProperties(properties.get());
    }

    public ImapIdleChannelAdapterSpec javaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.assertReceiver();
        this.assertSession();
        this.receiver.setJavaMailAuthenticator(javaMailAuthenticator);
        return this;
    }

    public ImapIdleChannelAdapterSpec maxFetchSize(int maxFetchSize) {
        this.assertReceiver();
        this.receiver.setMaxFetchSize(maxFetchSize);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldDeleteMessages(boolean shouldDeleteMessages) {
        this.assertReceiver();
        this.receiver.setShouldDeleteMessages(shouldDeleteMessages);
        return this;
    }

    public ImapIdleChannelAdapterSpec searchTermStrategy(SearchTermStrategy searchTermStrategy) {
        this.assertReceiver();
        this.receiver.setSearchTermStrategy(searchTermStrategy);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldMarkMessagesAsRead(boolean shouldMarkMessagesAsRead) {
        this.assertReceiver();
        this.receiver.setShouldMarkMessagesAsRead(shouldMarkMessagesAsRead);
        return this;
    }

    public ImapIdleChannelAdapterSpec userFlag(String userFlag) {
        this.assertReceiver();
        this.receiver.setUserFlag(userFlag);
        return (ImapIdleChannelAdapterSpec)this._this();
    }

    public ImapIdleChannelAdapterSpec headerMapper(HeaderMapper<MimeMessage> headerMapper) {
        this.assertReceiver();
        this.receiver.setHeaderMapper(headerMapper);
        return (ImapIdleChannelAdapterSpec)this._this();
    }

    public ImapIdleChannelAdapterSpec embeddedPartsAsBytes(boolean embeddedPartsAsBytes) {
        this.assertReceiver();
        this.receiver.setEmbeddedPartsAsBytes(embeddedPartsAsBytes);
        return (ImapIdleChannelAdapterSpec)this._this();
    }

    public ImapIdleChannelAdapterSpec autoCloseFolder(boolean autoCloseFolder) {
        this.assertReceiver();
        this.receiver.setAutoCloseFolder(autoCloseFolder);
        return (ImapIdleChannelAdapterSpec)this._this();
    }

    public ImapIdleChannelAdapterSpec transactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        ((ImapIdleChannelAdapter)((Object)this.target)).setTransactionSynchronizationFactory(transactionSynchronizationFactory);
        return this;
    }

    public ImapIdleChannelAdapterSpec adviceChain(Advice ... adviceChain) {
        this.adviceChain.addAll(Arrays.asList(adviceChain));
        return this;
    }

    public ImapIdleChannelAdapterSpec transactional(TransactionManager transactionManager) {
        return this.transactional(new TransactionInterceptorBuilder(false).transactionManager(transactionManager).build());
    }

    public ImapIdleChannelAdapterSpec transactional(TransactionInterceptor transactionInterceptor) {
        return this.adviceChain(new Advice[]{transactionInterceptor});
    }

    public ImapIdleChannelAdapterSpec transactional() {
        TransactionInterceptor transactionInterceptor = new TransactionInterceptorBuilder(false).build();
        this.componentsToRegister.put(transactionInterceptor, null);
        return this.transactional(transactionInterceptor);
    }

    public ImapIdleChannelAdapterSpec sendingTaskExecutor(Executor sendingTaskExecutor) {
        ((ImapIdleChannelAdapter)((Object)this.target)).setSendingTaskExecutor(sendingTaskExecutor);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        ((ImapIdleChannelAdapter)((Object)this.target)).setShouldReconnectAutomatically(shouldReconnectAutomatically);
        return this;
    }

    public ImapIdleChannelAdapterSpec cancelIdleInterval(long interval) {
        this.assertReceiver();
        this.receiver.setCancelIdleInterval(interval);
        return this;
    }

    public Map<Object, String> getComponentsToRegister() {
        return this.componentsToRegister;
    }
}

