/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.dsl;

import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.integration.dsl.IntegrationComponentSpec;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.GenericErrorHandler;
import org.springframework.kafka.support.TopicPartitionOffset;

public class KafkaMessageListenerContainerSpec<K, V>
extends IntegrationComponentSpec<KafkaMessageListenerContainerSpec<K, V>, ConcurrentMessageListenerContainer<K, V>> {
    KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties) {
        this.target = new ConcurrentMessageListenerContainer(consumerFactory, containerProperties);
    }

    KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, TopicPartitionOffset ... topicPartitions) {
        this(consumerFactory, new ContainerProperties(topicPartitions));
    }

    KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, String ... topics) {
        this(consumerFactory, new ContainerProperties(topics));
    }

    KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, Pattern topicPattern) {
        this(consumerFactory, new ContainerProperties(topicPattern));
    }

    public KafkaMessageListenerContainerSpec<K, V> id(String id) {
        return (KafkaMessageListenerContainerSpec)super.id(id);
    }

    public KafkaMessageListenerContainerSpec<K, V> concurrency(int concurrency) {
        ((ConcurrentMessageListenerContainer)this.target).setConcurrency(concurrency);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> errorHandler(GenericErrorHandler<?> errorHandler) {
        ((ConcurrentMessageListenerContainer)this.target).setGenericErrorHandler(errorHandler);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> ackMode(ContainerProperties.AckMode ackMode) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setAckMode(ackMode);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> pollTimeout(long pollTimeout) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setPollTimeout(pollTimeout);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> ackCount(int count) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setAckCount(count);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> ackTime(long millis) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setAckTime(millis);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> consumerTaskExecutor(AsyncListenableTaskExecutor consumerTaskExecutor) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setConsumerTaskExecutor(consumerTaskExecutor);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> shutdownTimeout(long shutdownTimeout) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setShutdownTimeout(shutdownTimeout);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> consumerRebalanceListener(ConsumerRebalanceListener consumerRebalanceListener) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setConsumerRebalanceListener(consumerRebalanceListener);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> commitCallback(OffsetCommitCallback commitCallback) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setCommitCallback(commitCallback);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> syncCommits(boolean syncCommits) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setSyncCommits(syncCommits);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> idleEventInterval(Long idleEventInterval) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setIdleEventInterval(idleEventInterval);
        return this;
    }

    @Deprecated
    public KafkaMessageListenerContainerSpec<K, V> ackOnError(boolean ackOnError) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setAckOnError(ackOnError);
        return this;
    }

    public KafkaMessageListenerContainerSpec<K, V> groupId(String groupId) {
        ((ConcurrentMessageListenerContainer)this.target).getContainerProperties().setGroupId(groupId);
        return this;
    }
}

