/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessagingGatewaySpec;
import org.springframework.integration.kafka.dsl.KafkaMessageListenerContainerSpec;
import org.springframework.integration.kafka.dsl.KafkaTemplateSpec;
import org.springframework.integration.kafka.inbound.KafkaInboundGateway;
import org.springframework.integration.support.ObjectStringMapBuilder;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class KafkaInboundGatewaySpec<K, V, R, S extends KafkaInboundGatewaySpec<K, V, R, S>>
extends MessagingGatewaySpec<S, KafkaInboundGateway<K, V, R>>
implements ComponentsRegistration {
    private final AbstractMessageListenerContainer<K, V> container;

    KafkaInboundGatewaySpec(AbstractMessageListenerContainer<K, V> messageListenerContainer, KafkaTemplate<K, R> kafkaTemplate) {
        super(new KafkaInboundGateway<K, V, R>(messageListenerContainer, kafkaTemplate));
        this.container = messageListenerContainer;
    }

    public S messageConverter(RecordMessageConverter messageConverter) {
        ((KafkaInboundGateway)((Object)this.target)).setMessageConverter(messageConverter);
        return (S)((Object)((KafkaInboundGatewaySpec)this._this()));
    }

    public S retryTemplate(RetryTemplate retryTemplate) {
        ((KafkaInboundGateway)((Object)this.target)).setRetryTemplate(retryTemplate);
        return (S)((Object)((KafkaInboundGatewaySpec)this._this()));
    }

    public S recoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        ((KafkaInboundGateway)((Object)this.target)).setRecoveryCallback(recoveryCallback);
        return (S)((Object)((KafkaInboundGatewaySpec)this._this()));
    }

    public S onPartitionsAssignedSeekCallback(BiConsumer<Map<TopicPartition, Long>, ConsumerSeekAware.ConsumerSeekCallback> onPartitionsAssignedCallback) {
        ((KafkaInboundGateway)((Object)this.target)).setOnPartitionsAssignedSeekCallback(onPartitionsAssignedCallback);
        return (S)((Object)((KafkaInboundGatewaySpec)this._this()));
    }

    public Map<Object, String> getComponentsToRegister() {
        return Collections.singletonMap(this.container, this.getId() == null ? null : this.getId() + ".container");
    }

    public static class KafkaInboundGatewayListenerContainerSpec<K, V, R>
    extends KafkaInboundGatewaySpec<K, V, R, KafkaInboundGatewayListenerContainerSpec<K, V, R>>
    implements ComponentsRegistration {
        private final KafkaMessageListenerContainerSpec<K, V> containerSpec;
        private final KafkaTemplateSpec<K, R> templateSpec;

        KafkaInboundGatewayListenerContainerSpec(KafkaMessageListenerContainerSpec<K, V> containerSpec, KafkaTemplateSpec<K, R> templateSpec) {
            super((AbstractMessageListenerContainer)containerSpec.get(), templateSpec.getTemplate());
            this.containerSpec = containerSpec;
            this.templateSpec = templateSpec;
        }

        public KafkaInboundGatewayListenerContainerSpec<K, V, R> configureListenerContainer(Consumer<KafkaMessageListenerContainerSpec<K, V>> configurer) {
            Assert.notNull(configurer, (String)"The 'configurer' cannot be null");
            configurer.accept(this.containerSpec);
            return (KafkaInboundGatewayListenerContainerSpec)this._this();
        }

        public KafkaInboundGatewayListenerContainerSpec<K, V, R> configureTemplate(Consumer<KafkaTemplateSpec<K, R>> configurer) {
            Assert.notNull(configurer, (String)"The 'configurer' cannot be null");
            configurer.accept(this.templateSpec);
            return (KafkaInboundGatewayListenerContainerSpec)this._this();
        }

        @Override
        public Map<Object, String> getComponentsToRegister() {
            return ((ObjectStringMapBuilder)((ObjectStringMapBuilder)new ObjectStringMapBuilder().put(this.containerSpec.get(), (Object)this.containerSpec.getId())).put(this.templateSpec.get(), (Object)this.templateSpec.getId())).get();
        }
    }
}

