/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import kafka.producer.Partitioner;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.util.Assert;

public class ProducerMetadata<K, V> {
    private final Class<K> keyClassType;
    private final Class<V> valueClassType;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private final String topic;
    private Partitioner partitioner;
    private CompressionType compressionType = CompressionType.none;
    private int batchBytes = 16384;

    public ProducerMetadata(String topic, Class<K> keyClassType, Class<V> valueClassType, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        Assert.notNull((Object)topic, (String)"Topic cannot be null");
        Assert.notNull(keyClassType, (String)"Key class type serializer cannot be null");
        Assert.notNull(valueClassType, (String)"Value class type cannot be null");
        Assert.notNull(keySerializer, (String)"Value serializer cannot be null");
        Assert.notNull(valueSerializer, (String)"Value serializer cannot be null");
        this.topic = topic;
        this.keyClassType = keyClassType;
        this.valueClassType = valueClassType;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public String getTopic() {
        return this.topic;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        Assert.notNull((Object)((Object)compressionType), (String)"Compression type cannot be null");
        this.compressionType = compressionType;
    }

    public int getBatchBytes() {
        return this.batchBytes;
    }

    public void setBatchBytes(int batchBytes) {
        Assert.isTrue((batchBytes > 0 ? 1 : 0) != 0, (String)"Buffer size must be greater than zero");
        this.batchBytes = batchBytes;
    }

    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    public Class<K> getKeyClassType() {
        return this.keyClassType;
    }

    public Class<V> getValueClassType() {
        return this.valueClassType;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProducerMetadata [keyEncoder=").append(this.keySerializer).append(", valueEncoder=").append(this.valueSerializer).append(", topic=").append(this.topic).append(", compressionType=").append((Object)this.compressionType).append("batchBytes").append(this.batchBytes).append("]");
        return builder.toString();
    }

    public static enum CompressionType {
        none,
        gzip,
        snappy;

    }
}

