/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.message.MessageAndMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.kafka.support.ConsumerConnectionProvider;
import org.springframework.integration.kafka.support.ConsumerMetadata;
import org.springframework.integration.kafka.support.MessageLeftOverTracker;
import org.springframework.integration.kafka.support.TopicFilterConfiguration;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;

public class ConsumerConfiguration<K, V> {
    private static final Log LOGGER = LogFactory.getLog(ConsumerConfiguration.class);
    private final ConsumerMetadata<K, V> consumerMetadata;
    private final ConsumerConnectionProvider consumerConnectionProvider;
    private final MessageLeftOverTracker<K, V> messageLeftOverTracker;
    private ConsumerConnector consumerConnector;
    private volatile int count = 0;
    private int maxMessages = 1;
    private Collection<List<KafkaStream<K, V>>> consumerMessageStreams;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private boolean executorExplicitlySet;
    private volatile boolean stopped;

    public ConsumerConfiguration(ConsumerMetadata<K, V> consumerMetadata, ConsumerConnectionProvider consumerConnectionProvider, MessageLeftOverTracker<K, V> messageLeftOverTracker) {
        this.consumerMetadata = consumerMetadata;
        this.consumerConnectionProvider = consumerConnectionProvider;
        this.messageLeftOverTracker = messageLeftOverTracker;
    }

    public void setExecutor(Executor executor) {
        boolean isExecutorService = executor instanceof ExecutorService;
        boolean isThreadPoolTaskExecutor = executor instanceof ThreadPoolTaskExecutor;
        Assert.isTrue((isExecutorService || isThreadPoolTaskExecutor ? 1 : 0) != 0);
        this.executorService = isExecutorService ? (ExecutorService)executor : ((ThreadPoolTaskExecutor)executor).getThreadPoolExecutor();
        this.executorExplicitlySet = true;
    }

    public ConsumerMetadata<K, V> getConsumerMetadata() {
        return this.consumerMetadata;
    }

    public Map<String, Map<Integer, List<Object>>> receive() {
        this.count = this.messageLeftOverTracker.getCurrentCount();
        final Object lock = new Object();
        LinkedList<Callable<List<MessageAndMetadata<K, V>>>> tasks = new LinkedList<Callable<List<MessageAndMetadata<K, V>>>>();
        for (List<KafkaStream<K, V>> streams : this.createConsumerMessageStreams()) {
            for (final KafkaStream<K, V> stream : streams) {
                tasks.add(new Callable<List<MessageAndMetadata<K, V>>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public List<MessageAndMetadata<K, V>> call() throws Exception {
                        ArrayList rawMessages = new ArrayList();
                        try {
                            while (ConsumerConfiguration.this.count < ConsumerConfiguration.this.maxMessages) {
                                MessageAndMetadata messageAndMetadata = stream.iterator().next();
                                Object object = lock;
                                synchronized (object) {
                                    if (ConsumerConfiguration.this.count < ConsumerConfiguration.this.maxMessages) {
                                        rawMessages.add(messageAndMetadata);
                                        ConsumerConfiguration.this.count++;
                                    } else {
                                        ConsumerConfiguration.this.messageLeftOverTracker.addMessageAndMetadata(messageAndMetadata);
                                    }
                                }
                            }
                            return rawMessages;
                        }
                        catch (ConsumerTimeoutException cte) {
                            LOGGER.debug((Object)"Consumer timed out");
                        }
                        return rawMessages;
                    }
                });
            }
        }
        return this.executeTasks(tasks);
    }

    private Map<String, Map<Integer, List<Object>>> executeTasks(List<Callable<List<MessageAndMetadata<K, V>>>> tasks) {
        ConcurrentHashMap<String, Map<Integer, List<Object>>> messages = new ConcurrentHashMap<String, Map<Integer, List<Object>>>();
        messages.putAll(this.getLeftOverMessageMap());
        try {
            for (Future<List<MessageAndMetadata<K, V>>> result : this.executorService.invokeAll(tasks)) {
                if (result.get().isEmpty()) continue;
                String topic = result.get().get(0).topic();
                if (!messages.containsKey(topic)) {
                    messages.put(topic, this.getPayload(result.get()));
                    continue;
                }
                Map existingPayloadMap = (Map)messages.get(topic);
                this.getPayload(result.get(), existingPayloadMap);
            }
        }
        catch (Exception e) {
            if (!this.stopped) {
                throw new MessagingException("Consuming from Kafka failed", (Throwable)e);
            }
            LOGGER.warn((Object)"Consuming from Kafka failed", (Throwable)e);
        }
        if (messages.isEmpty()) {
            return null;
        }
        return messages;
    }

    private Map<String, Map<Integer, List<Object>>> getLeftOverMessageMap() {
        ConcurrentHashMap<String, Map<Integer, List<Object>>> messages = new ConcurrentHashMap<String, Map<Integer, List<Object>>>();
        for (MessageAndMetadata<K, V> mamd : this.messageLeftOverTracker.getMessageLeftOverFromPreviousPoll()) {
            String topic = mamd.topic();
            if (!messages.containsKey(topic)) {
                ArrayList<MessageAndMetadata<K, V>> l = new ArrayList<MessageAndMetadata<K, V>>();
                l.add(mamd);
                messages.put(topic, this.getPayload(l));
                continue;
            }
            Map existingPayloadMap = (Map)messages.get(topic);
            ArrayList<MessageAndMetadata<K, V>> l = new ArrayList<MessageAndMetadata<K, V>>();
            l.add(mamd);
            this.getPayload(l, existingPayloadMap);
        }
        this.messageLeftOverTracker.clearMessagesLeftOver();
        return messages;
    }

    private Map<Integer, List<Object>> getPayload(List<MessageAndMetadata<K, V>> messageAndMetadatas) {
        ConcurrentHashMap<Integer, List<Object>> payloadMap = new ConcurrentHashMap<Integer, List<Object>>();
        for (MessageAndMetadata<K, V> messageAndMetadata : messageAndMetadatas) {
            List<Object> payload;
            if (!payloadMap.containsKey(messageAndMetadata.partition())) {
                payload = new ArrayList<Object>();
                payload.add(messageAndMetadata.message());
                payloadMap.put(messageAndMetadata.partition(), payload);
                continue;
            }
            payload = (List)payloadMap.get(messageAndMetadata.partition());
            payload.add(messageAndMetadata.message());
        }
        return payloadMap;
    }

    private void getPayload(List<MessageAndMetadata<K, V>> messageAndMetadatas, Map<Integer, List<Object>> existingPayloadMap) {
        for (MessageAndMetadata<K, V> messageAndMetadata : messageAndMetadatas) {
            List<Object> payload;
            if (!existingPayloadMap.containsKey(messageAndMetadata.partition())) {
                payload = new ArrayList<Object>();
                payload.add(messageAndMetadata.message());
                existingPayloadMap.put(messageAndMetadata.partition(), payload);
                continue;
            }
            payload = existingPayloadMap.get(messageAndMetadata.partition());
            payload.add(messageAndMetadata.message());
        }
    }

    private Collection<List<KafkaStream<K, V>>> createConsumerMessageStreams() {
        if (this.consumerMessageStreams == null) {
            if (this.consumerMetadata.getTopicStreamMap() != null && !this.consumerMetadata.getTopicStreamMap().isEmpty()) {
                this.consumerMessageStreams = this.createMessageStreamsForTopic().values();
            } else {
                this.consumerMessageStreams = new ArrayList<List<KafkaStream<K, V>>>();
                this.consumerMessageStreams.add(this.createMessageStreamsForTopicFilter());
            }
        }
        return this.consumerMessageStreams;
    }

    public Map<String, List<KafkaStream<K, V>>> createMessageStreamsForTopic() {
        return this.getConsumerConnector().createMessageStreams(this.consumerMetadata.getTopicStreamMap(), this.consumerMetadata.getKeyDecoder(), this.consumerMetadata.getValueDecoder());
    }

    public List<KafkaStream<K, V>> createMessageStreamsForTopicFilter() {
        List<Object> messageStream = new ArrayList<KafkaStream<K, V>>();
        TopicFilterConfiguration topicFilterConfiguration = this.consumerMetadata.getTopicFilterConfiguration();
        if (topicFilterConfiguration != null) {
            messageStream = this.getConsumerConnector().createMessageStreamsByFilter(topicFilterConfiguration.getTopicFilter(), topicFilterConfiguration.getNumberOfStreams(), this.consumerMetadata.getKeyDecoder(), this.consumerMetadata.getValueDecoder());
        } else {
            LOGGER.warn((Object)"No Topic Filter Configuration defined");
        }
        return messageStream;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public ConsumerConnector getConsumerConnector() {
        if (this.consumerConnector == null) {
            this.consumerConnector = this.consumerConnectionProvider.getConsumerConnector();
        }
        return this.consumerConnector;
    }

    public void shutdown() {
        this.stopped = true;
        if (!this.executorExplicitlySet) {
            this.executorService.shutdownNow();
        }
        this.getConsumerConnector().shutdown();
    }
}

