/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.core;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.utility.Iterate;
import java.util.Collection;
import java.util.Map;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import org.springframework.integration.kafka.core.BrokerAddress;
import org.springframework.integration.kafka.core.Partition;

class MetadataCache {
    public static final GetTopicNameFunction getTopicNameFunction = new GetTopicNameFunction();
    public static final ToIndexedPartitionMetadataFunction toIndexedPartitionMetadataFunction = new ToIndexedPartitionMetadataFunction();
    private final Map<String, Map<Partition, PartitionMetadata>> metadatasByTopic;

    public MetadataCache(Iterable<TopicMetadata> topicMetadatas) {
        UnifiedMap topicData = UnifiedMap.newMap();
        for (TopicMetadata topicMetadata : topicMetadatas) {
            Map<Partition, PartitionMetadata> partitionData = MetadataCache.toPartitionMetadataMap(topicMetadata);
            topicData.put((Object)topicMetadata.topic(), partitionData);
        }
        this.metadatasByTopic = topicData.toImmutable().castToMap();
    }

    private MetadataCache(Map<String, Map<Partition, PartitionMetadata>> metadatasByTopic) {
        this.metadatasByTopic = metadatasByTopic;
    }

    public MetadataCache merge(Iterable<TopicMetadata> topicMetadatas) {
        UnifiedMap unifiedMap = UnifiedMap.newMap(this.metadatasByTopic);
        return new MetadataCache(((UnifiedMap)Iterate.addToMap(topicMetadatas, (Function)getTopicNameFunction, (Function)toIndexedPartitionMetadataFunction, (Map)unifiedMap)).toImmutable().castToMap());
    }

    public Collection<Partition> getPartitions(String topic) {
        if (this.metadatasByTopic.containsKey(topic)) {
            return this.metadatasByTopic.get(topic).keySet();
        }
        return null;
    }

    public BrokerAddress getLeader(Partition partition) {
        if (!this.metadatasByTopic.containsKey(partition.getTopic())) {
            return null;
        }
        Map<Partition, PartitionMetadata> partitionMetadatasForTopic = this.metadatasByTopic.get(partition.getTopic());
        if (!partitionMetadatasForTopic.containsKey(partition)) {
            return null;
        }
        return new BrokerAddress(partitionMetadatasForTopic.get(partition).leader());
    }

    private static Map<Partition, PartitionMetadata> toPartitionMetadataMap(TopicMetadata topicMetadata) {
        UnifiedMap partitionData = UnifiedMap.newMap();
        for (PartitionMetadata partitionMetadata : topicMetadata.partitionsMetadata()) {
            partitionData.put(new Partition(topicMetadata.topic(), partitionMetadata.partitionId()), partitionMetadata);
        }
        return partitionData;
    }

    private static class ToIndexedPartitionMetadataFunction
    implements Function<TopicMetadata, Map<Partition, PartitionMetadata>> {
        private ToIndexedPartitionMetadataFunction() {
        }

        public Map<Partition, PartitionMetadata> valueOf(TopicMetadata object) {
            return MetadataCache.toPartitionMetadataMap(object);
        }
    }

    private static class GetTopicNameFunction
    implements Function<TopicMetadata, String> {
        private GetTopicNameFunction() {
        }

        public String valueOf(TopicMetadata object) {
            return object.topic();
        }
    }
}

