/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support;

import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class JpaParameter {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private String name;
    private Object value;
    private String expression;
    private Expression spelExpression;
    private Expression projectionExpression;

    public JpaParameter() {
    }

    public JpaParameter(String name, Object value, String expression) {
        Assert.hasText((String)name, (String)"'name' must not be empty.");
        this.name = name;
        this.value = value;
        this.setExpression(expression);
    }

    public JpaParameter(Object value, String expression) {
        this.value = value;
        this.setExpression(expression);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getExpression() {
        return this.expression;
    }

    public Expression getSpelExpression() {
        return this.spelExpression;
    }

    public Expression getProjectionExpression() {
        return this.projectionExpression;
    }

    public final void setExpression(String expression) {
        this.expression = expression;
        this.spelExpression = PARSER.parseExpression(expression);
        this.projectionExpression = PARSER.parseExpression("#root.![" + expression + "]");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JpaParameter [name=").append(this.name).append(", value=").append(this.value).append(", expression=").append(this.expression).append("]");
        return builder.toString();
    }
}

