/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.inbound;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.jmx.inbound.DefaultMBeanAttributeFilter;
import org.springframework.integration.jmx.inbound.MBeanAttributeFilter;
import org.springframework.integration.jmx.inbound.MBeanObjectConverter;
import org.springframework.util.Assert;

public class DefaultMBeanObjectConverter
implements MBeanObjectConverter {
    private static final Log LOGGER = LogFactory.getLog(DefaultMBeanObjectConverter.class);
    private final MBeanAttributeFilter filter;

    public DefaultMBeanObjectConverter() {
        this(new DefaultMBeanAttributeFilter());
    }

    public DefaultMBeanObjectConverter(MBeanAttributeFilter filter) {
        Assert.notNull((Object)filter, (String)"'filter' must not be null.");
        this.filter = filter;
    }

    @Override
    public Object convert(MBeanServerConnection connection, ObjectInstance instance) {
        HashMap<String, @Nullable Object> attributeMap = new HashMap<String, Object>();
        try {
            MBeanAttributeInfo[] attributeInfos;
            ObjectName objName = instance.getObjectName();
            if (!connection.isRegistered(objName)) {
                return attributeMap;
            }
            MBeanInfo info = connection.getMBeanInfo(objName);
            for (MBeanAttributeInfo attrInfo : attributeInfos = info.getAttributes()) {
                Object value;
                if ("ObjectName".equals(attrInfo.getName()) || !this.filter.accept(objName, attrInfo.getName())) continue;
                try {
                    value = connection.getAttribute(objName, attrInfo.getName());
                }
                catch (RuntimeMBeanException e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Error getting attribute '" + attrInfo.getName() + "' on '" + String.valueOf(objName) + "'"), (Throwable)e);
                    }
                    Throwable t = e;
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    value = String.format("%s[%s]", t.getClass().getName(), t.getMessage());
                }
                attributeMap.put(attrInfo.getName(), this.checkAndConvert(value));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return attributeMap;
    }

    private @Nullable Object checkAndConvert(@Nullable Object input) {
        Object converted = null;
        if (input instanceof CompositeData) {
            converted = this.convertFromCompositeData((CompositeData)input);
        } else if (input instanceof TabularData) {
            converted = this.convertFromTabularData((TabularData)input);
        } else if (input != null && input.getClass().isArray()) {
            converted = this.convertFromArray(input);
        }
        if (converted != null) {
            return converted;
        }
        return input;
    }

    private @Nullable Object convertFromArray(Object input) {
        if (CompositeData.class.isAssignableFrom(input.getClass().getComponentType())) {
            int length = Array.getLength(input);
            ArrayList<@Nullable Object> converted = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                Object value = this.checkAndConvert(Array.get(input, i));
                converted.add(value);
            }
            return converted;
        }
        if (TabularData.class.isAssignableFrom(input.getClass().getComponentType())) {
            LOGGER.warn((Object)("TabularData.isAssignableFrom(getComponentType) for " + input.toString()));
        }
        return null;
    }

    private @Nullable Object convertFromCompositeData(CompositeData data) {
        if (data.getCompositeType().isArray()) {
            LOGGER.warn((Object)("(data.getCompositeType().isArray for " + String.valueOf(data)));
            return null;
        }
        HashMap<String, @Nullable Object> returnable = new HashMap<String, Object>();
        Set<String> keys = data.getCompositeType().keySet();
        for (String key : keys) {
            if ("ObjectName".equals(key)) continue;
            Object value = this.checkAndConvert(data.get(key));
            returnable.put(key, value);
        }
        return returnable;
    }

    private @Nullable Object convertFromTabularData(TabularData data) {
        if (data.getTabularType().isArray()) {
            LOGGER.warn((Object)("TabularData.isArray for " + String.valueOf(data)));
            return null;
        }
        HashMap<Object, @Nullable Object> returnable = new HashMap<Object, Object>();
        Set<?> keySet = data.keySet();
        for (List keys : keySet) {
            Map valueMap;
            CompositeData cd = data.get(keys.toArray());
            Object value = this.checkAndConvert(cd);
            if (keys.size() == 1 && value instanceof Map && (valueMap = (Map)value).size() == 2) {
                Object actualKey = keys.get(0);
                if (valueMap.containsKey("key") && valueMap.containsKey("value") && actualKey.equals(valueMap.get("key"))) {
                    returnable.put(valueMap.get("key"), valueMap.get("value"));
                    continue;
                }
                returnable.put(actualKey, value);
                continue;
            }
            returnable.put(keys, value);
        }
        return returnable;
    }
}

