/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import java.util.concurrent.atomic.AtomicLong;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.integration.monitor.DirectChannelMetrics;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.support.MetricType;
import org.springframework.messaging.MessageChannel;

public class PollableChannelMetrics
extends DirectChannelMetrics {
    private final AtomicLong receiveCount = new AtomicLong();
    private final AtomicLong receiveErrorCount = new AtomicLong();

    public PollableChannelMetrics(MessageChannel messageChannel, String name) {
        super(messageChannel, name);
    }

    @Override
    protected Object doInvoke(MethodInvocation invocation, String method, MessageChannel channel) throws Throwable {
        if ("receive".equals(method)) {
            return this.monitorReceive(invocation, channel);
        }
        return super.doInvoke(invocation, method, channel);
    }

    private Object monitorReceive(MethodInvocation invocation, MessageChannel channel) throws Throwable {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Recording receive on channel(" + channel + ") "));
        }
        try {
            Object object = invocation.proceed();
            if (object != null) {
                this.receiveCount.incrementAndGet();
            }
            return object;
        }
        catch (Throwable e) {
            this.receiveErrorCount.incrementAndGet();
            throw e;
        }
    }

    @Override
    @ManagedOperation
    public synchronized void reset() {
        super.reset();
        this.receiveErrorCount.set(0L);
        this.receiveCount.set(0L);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Receive Count")
    public int getReceiveCount() {
        return (int)this.receiveCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Receive Count")
    public long getReceiveCountLong() {
        return this.receiveCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Receive Error Count")
    public int getReceiveErrorCount() {
        return (int)this.receiveErrorCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Receive Error Count")
    public long getReceiveErrorCountLong() {
        return this.receiveErrorCount.get();
    }

    @Override
    public String toString() {
        return String.format("MessageChannelMonitor: [name=%s, sends=%d, receives=%d]", this.getName(), this.getSendCount(), this.receiveCount.get());
    }
}

