/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import org.springframework.integration.monitor.Statistics;

public class ExponentialMovingAverage {
    private volatile long count;
    private volatile double weight;
    private volatile double sum;
    private volatile double sumSquares;
    private volatile double min;
    private volatile double max;
    private final double decay;

    public ExponentialMovingAverage(int window) {
        this.decay = 1.0 - 1.0 / (double)window;
    }

    public synchronized void reset() {
        this.weight = 0.0;
        this.sum = 0.0;
        this.sumSquares = 0.0;
        this.count = 0L;
        this.min = 0.0;
        this.max = 0.0;
    }

    public synchronized void append(double value) {
        if (value > this.max || this.count == 0L) {
            this.max = value;
        }
        if (value < this.min || this.count == 0L) {
            this.min = value;
        }
        this.sum = this.decay * this.sum + value;
        this.sumSquares = this.decay * this.sumSquares + value * value;
        this.weight = this.decay * this.weight + 1.0;
        ++this.count;
    }

    public int getCount() {
        return (int)this.count;
    }

    public long getCountLong() {
        return this.count;
    }

    public double getMean() {
        return this.weight > 0.0 ? this.sum / this.weight : 0.0;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        double var = this.weight > 0.0 ? this.sumSquares / this.weight - mean * mean : 0.0;
        return var > 0.0 ? Math.sqrt(var) : 0.0;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public Statistics getStatistics() {
        return new Statistics(this.count, this.min, this.max, this.getMean(), this.getStandardDeviation());
    }

    public String toString() {
        return this.getStatistics().toString();
    }
}

