/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import java.util.concurrent.atomic.AtomicInteger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.monitor.MessageSourceMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMessageSourceMetrics
implements MethodInterceptor,
MessageSourceMetrics {
    private final AtomicInteger messageCount = new AtomicInteger();
    private final MessageSource<?> messageSource;
    private volatile String source;
    private volatile String name;

    public SimpleMessageSourceMetrics(MessageSource<?> messageSource) {
        this.messageSource = messageSource;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public MessageSource<?> getMessageSource() {
        return this.messageSource;
    }

    @Override
    public void reset() {
        this.messageCount.set(0);
    }

    @Override
    public int getMessageCount() {
        return this.messageCount.get();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String method = invocation.getMethod().getName();
        Object result = invocation.proceed();
        if ("receive".equals(method) && result != null) {
            this.messageCount.incrementAndGet();
        }
        return result;
    }

    public String toString() {
        return String.format("MessageSourceMonitor: [name=%s, source=%s, count=%d]", this.name, this.source, this.messageCount.get());
    }
}

