/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import java.util.List;
import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.DynamicJmsTemplate;
import org.springframework.integration.jms.PollableJmsChannel;
import org.springframework.integration.jms.SubscribableJmsChannel;
import org.springframework.integration.util.JavaUtils;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ErrorHandler;
import org.springframework.util.StringUtils;

public class JmsChannelFactoryBean
extends AbstractFactoryBean<AbstractJmsChannel>
implements SmartLifecycle,
BeanNameAware {
    private volatile AbstractJmsChannel channel;
    private volatile List<ChannelInterceptor> interceptors;
    private final boolean messageDriven;
    private final JmsTemplate jmsTemplate = new DynamicJmsTemplate();
    private AbstractMessageListenerContainer listenerContainer;
    private Class<? extends AbstractMessageListenerContainer> containerType;
    private boolean acceptMessagesWhileStopping;
    private boolean autoStartup = true;
    private String cacheLevelName;
    private Integer cacheLevel;
    private String clientId;
    private String concurrency;
    private Integer concurrentConsumers;
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private String destinationName;
    private DestinationResolver destinationResolver;
    private String durableSubscriptionName;
    private ErrorHandler errorHandler;
    private ExceptionListener exceptionListener;
    private Boolean exposeListenerSession;
    private Integer idleTaskExecutionLimit;
    private Integer maxConcurrentConsumers;
    private Integer maxMessagesPerTask;
    private String messageSelector;
    private Integer phase;
    private Boolean pubSubDomain;
    private boolean pubSubNoLocal;
    private Long receiveTimeout;
    private Long recoveryInterval;
    private String beanName;
    private boolean subscriptionShared;
    private int sessionAcknowledgeMode = 0;
    private boolean sessionTransacted = true;
    private boolean subscriptionDurable;
    private Executor taskExecutor;
    private PlatformTransactionManager transactionManager;
    private String transactionName;
    private Integer transactionTimeout;
    private int maxSubscribers = Integer.MAX_VALUE;

    public JmsChannelFactoryBean() {
        this(true);
    }

    public JmsChannelFactoryBean(boolean messageDriven) {
        this.messageDriven = messageDriven;
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.jmsTemplate.setDeliveryPersistent(deliveryPersistent);
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.jmsTemplate.setExplicitQosEnabled(explicitQosEnabled);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.jmsTemplate.setMessageConverter(messageConverter);
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.jmsTemplate.setMessageIdEnabled(messageIdEnabled);
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.jmsTemplate.setMessageTimestampEnabled(messageTimestampEnabled);
    }

    public void setPriority(int priority) {
        this.jmsTemplate.setPriority(priority);
    }

    public void setTimeToLive(long timeToLive) {
        this.jmsTemplate.setTimeToLive(timeToLive);
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'acceptMessagesWhileStopping' is allowed only in case of 'messageDriven = true'");
        this.acceptMessagesWhileStopping = acceptMessagesWhileStopping;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setCacheLevelName(String cacheLevelName) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'cacheLevelName' is allowed only in case of 'messageDriven = true'");
        Assert.state((this.cacheLevel == null ? 1 : 0) != 0, (String)"'cacheLevelName' and 'cacheLevel' are mutually exclusive");
        this.cacheLevelName = cacheLevelName;
    }

    public void setCacheLevel(Integer cacheLevel) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'cacheLevel' is allowed only in case of 'messageDriven = true'");
        Assert.state((!StringUtils.hasText((String)this.cacheLevelName) ? 1 : 0) != 0, (String)"'cacheLevelName' and 'cacheLevel' are mutually exclusive");
        this.cacheLevel = cacheLevel;
    }

    public void setClientId(String clientId) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'clientId' is allowed only in case of 'messageDriven = true'");
        this.clientId = clientId;
    }

    public void setConcurrency(String concurrency) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'concurrency' is allowed only in case of 'messageDriven = true'");
        this.concurrency = concurrency;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'concurrentConsumers' is allowed only in case of 'messageDriven = true'");
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.jmsTemplate.setConnectionFactory(this.connectionFactory);
    }

    public void setContainerType(Class<? extends AbstractMessageListenerContainer> containerType) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'containerType' is allowed only in case of 'messageDriven = true'");
        this.containerType = containerType;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
        this.jmsTemplate.setDestinationResolver(destinationResolver);
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'durableSubscriptionName' is allowed only in case of 'messageDriven = true'");
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'errorHandler' is allowed only in case of 'messageDriven = true'");
        this.errorHandler = errorHandler;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'exceptionListener' is allowed only in case of 'messageDriven = true'");
        this.exceptionListener = exceptionListener;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'exposeListenerSession' is allowed only in case of 'messageDriven = true'");
        this.exposeListenerSession = exposeListenerSession;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'idleTaskExecutionLimit' is allowed only in case of 'messageDriven = true'");
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'maxConcurrentConsumers' is allowed only in case of 'messageDriven = true'");
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'maxMessagesPerTask' is allowed only in case of 'messageDriven = true'");
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
        this.jmsTemplate.setPubSubDomain(pubSubDomain);
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
        this.jmsTemplate.setPubSubNoLocal(pubSubNoLocal);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        this.jmsTemplate.setReceiveTimeout(receiveTimeout);
    }

    public void setRecoveryInterval(long recoveryInterval) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'recoveryInterval' is allowed only in case of 'messageDriven = true'");
        this.recoveryInterval = recoveryInterval;
    }

    public void setSessionAcknowledgeMode(int sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
        this.jmsTemplate.setSessionAcknowledgeMode(sessionAcknowledgeMode);
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
        this.jmsTemplate.setSessionTransacted(sessionTransacted);
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'subscriptionDurable' is allowed only in case of 'messageDriven = true'");
        this.subscriptionDurable = subscriptionDurable;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'taskExecutor' is allowed only in case of 'messageDriven = true'");
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'transactionManager' is allowed only in case of 'messageDriven = true'");
        this.transactionManager = transactionManager;
    }

    public void setTransactionName(String transactionName) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'transactionName' is allowed only in case of 'messageDriven = true'");
        this.transactionName = transactionName;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'transactionTimeout' is allowed only in case of 'messageDriven = true'");
        this.transactionTimeout = transactionTimeout;
    }

    public void setMaxSubscribers(int maxSubscribers) {
        Assert.isTrue((boolean)this.messageDriven, (String)"'maxSubscribers' is allowed only in case of 'messageDriven = true'");
        this.maxSubscribers = maxSubscribers;
    }

    public void setSubscriptionShared(boolean subscriptionShared) {
        this.subscriptionShared = subscriptionShared;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public Class<?> getObjectType() {
        return this.channel != null ? ((Object)((Object)this.channel)).getClass() : AbstractJmsChannel.class;
    }

    protected AbstractJmsChannel createInstance() {
        this.initializeJmsTemplate();
        if (this.messageDriven) {
            this.listenerContainer = this.createContainer();
            SubscribableJmsChannel subscribableJmsChannel = new SubscribableJmsChannel(this.listenerContainer, this.jmsTemplate);
            subscribableJmsChannel.setMaxSubscribers(this.maxSubscribers);
            this.channel = subscribableJmsChannel;
        } else {
            Assert.isTrue((!Boolean.TRUE.equals(this.pubSubDomain) ? 1 : 0) != 0, (String)"A JMS Topic-backed 'publish-subscribe-channel' must be message-driven.");
            PollableJmsChannel pollableJmschannel = new PollableJmsChannel(this.jmsTemplate);
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.messageSelector, pollableJmschannel::setMessageSelector);
            this.channel = pollableJmschannel;
        }
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            this.channel.setInterceptors(this.interceptors);
        }
        this.channel.setBeanName(this.beanName);
        BeanFactory beanFactory = this.getBeanFactory();
        JavaUtils.INSTANCE.acceptIfNotNull((Object)beanFactory, arg_0 -> ((AbstractJmsChannel)this.channel).setBeanFactory(arg_0));
        this.channel.afterPropertiesSet();
        return this.channel;
    }

    private void initializeJmsTemplate() {
        Assert.isTrue((boolean)(this.destination != null ^ this.destinationName != null), (String)"Exactly one of destination or destinationName is required.");
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.destination, arg_0 -> ((JmsTemplate)this.jmsTemplate).setDefaultDestination(arg_0)).acceptIfNotNull((Object)this.destinationName, arg_0 -> ((JmsTemplate)this.jmsTemplate).setDefaultDestinationName(arg_0));
    }

    private AbstractMessageListenerContainer createContainer() {
        if (this.containerType == null) {
            this.containerType = DefaultMessageListenerContainer.class;
        }
        AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)BeanUtils.instantiateClass(this.containerType);
        container.setAcceptMessagesWhileStopping(this.acceptMessagesWhileStopping);
        container.setAutoStartup(this.autoStartup);
        container.setClientId(this.clientId);
        container.setConnectionFactory(this.connectionFactory);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.destination, arg_0 -> ((AbstractMessageListenerContainer)container).setDestination(arg_0)).acceptIfNotNull((Object)this.destinationName, arg_0 -> ((AbstractMessageListenerContainer)container).setDestinationName(arg_0)).acceptIfNotNull((Object)this.destinationResolver, arg_0 -> ((AbstractMessageListenerContainer)container).setDestinationResolver(arg_0));
        container.setDurableSubscriptionName(this.durableSubscriptionName);
        container.setErrorHandler(this.errorHandler);
        container.setExceptionListener(this.exceptionListener);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.exposeListenerSession, arg_0 -> ((AbstractMessageListenerContainer)container).setExposeListenerSession(arg_0));
        container.setMessageSelector(this.messageSelector);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.phase, arg_0 -> ((AbstractMessageListenerContainer)container).setPhase(arg_0)).acceptIfNotNull((Object)this.pubSubDomain, arg_0 -> ((AbstractMessageListenerContainer)container).setPubSubDomain(arg_0));
        container.setSessionAcknowledgeMode(this.sessionAcknowledgeMode);
        container.setSessionTransacted(this.sessionTransacted);
        container.setSubscriptionDurable(this.subscriptionDurable);
        container.setSubscriptionShared(this.subscriptionShared);
        if (container instanceof DefaultMessageListenerContainer) {
            DefaultMessageListenerContainer dmlc = (DefaultMessageListenerContainer)container;
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.cacheLevelName, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setCacheLevelName(arg_0)).acceptIfNotNull((Object)this.cacheLevel, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setCacheLevel(arg_0)).acceptIfHasText(this.concurrency, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setConcurrency(arg_0)).acceptIfNotNull((Object)this.concurrentConsumers, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setConcurrentConsumers(arg_0)).acceptIfNotNull((Object)this.maxConcurrentConsumers, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setMaxConcurrentConsumers(arg_0)).acceptIfNotNull((Object)this.idleTaskExecutionLimit, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setIdleTaskExecutionLimit(arg_0)).acceptIfNotNull((Object)this.maxMessagesPerTask, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setMaxMessagesPerTask(arg_0));
            dmlc.setPubSubNoLocal(this.pubSubNoLocal);
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.receiveTimeout, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setReceiveTimeout(arg_0)).acceptIfNotNull((Object)this.recoveryInterval, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setRecoveryInterval(arg_0));
            dmlc.setTaskExecutor(this.taskExecutor);
            dmlc.setTransactionManager(this.transactionManager);
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.transactionName, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setTransactionName(arg_0)).acceptIfNotNull((Object)this.transactionTimeout, arg_0 -> ((DefaultMessageListenerContainer)dmlc).setTransactionTimeout(arg_0));
        } else if (container instanceof SimpleMessageListenerContainer) {
            SimpleMessageListenerContainer smlc = (SimpleMessageListenerContainer)container;
            JavaUtils.INSTANCE.acceptIfHasText(this.concurrency, arg_0 -> ((SimpleMessageListenerContainer)smlc).setConcurrency(arg_0)).acceptIfNotNull((Object)this.concurrentConsumers, arg_0 -> ((SimpleMessageListenerContainer)smlc).setConcurrentConsumers(arg_0));
            smlc.setPubSubNoLocal(this.pubSubNoLocal);
            smlc.setTaskExecutor(this.taskExecutor);
        }
        return container;
    }

    public boolean isAutoStartup() {
        return this.channel instanceof SubscribableJmsChannel && ((SubscribableJmsChannel)this.channel).isAutoStartup();
    }

    public int getPhase() {
        return this.channel instanceof SubscribableJmsChannel ? ((SubscribableJmsChannel)this.channel).getPhase() : 0;
    }

    public boolean isRunning() {
        return this.channel instanceof SubscribableJmsChannel && ((SubscribableJmsChannel)this.channel).isRunning();
    }

    public void start() {
        if (this.channel instanceof SubscribableJmsChannel) {
            ((SubscribableJmsChannel)this.channel).start();
        }
    }

    public void stop() {
        if (this.channel instanceof SubscribableJmsChannel) {
            ((SubscribableJmsChannel)this.channel).stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.channel instanceof SubscribableJmsChannel) {
            ((SubscribableJmsChannel)this.channel).stop(callback);
        } else {
            callback.run();
        }
    }

    protected void destroyInstance(AbstractJmsChannel instance) {
        this.channel.destroy();
    }
}

