/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.ArrayDeque;
import java.util.List;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.ExecutorChannelInterceptorAware;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.integration.support.management.metrics.CounterFacade;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;

public class PollableJmsChannel
extends AbstractJmsChannel
implements PollableChannel,
PollableChannelManagement,
ExecutorChannelInterceptorAware {
    private String messageSelector;
    private CounterFacade receiveCounter;
    private volatile int executorInterceptorsSize;

    public PollableJmsChannel(JmsTemplate jmsTemplate) {
        super(jmsTemplate);
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getReceiveCount() {
        return this.getMetrics().getReceiveCount();
    }

    public long getReceiveCountLong() {
        return this.getMetrics().getReceiveCountLong();
    }

    public int getReceiveErrorCount() {
        return this.getMetrics().getReceiveErrorCount();
    }

    public long getReceiveErrorCountLong() {
        return this.getMetrics().getReceiveErrorCountLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Message<?> receive(long timeout) {
        try {
            DynamicJmsTemplateProperties.setReceiveTimeout(timeout);
            Message<?> message = this.receive();
            return message;
        }
        finally {
            DynamicJmsTemplateProperties.clearReceiveTimeout();
        }
    }

    @Nullable
    public Message<?> receive() {
        AbstractMessageChannel.ChannelInterceptorList interceptorList = this.getInterceptors();
        ArrayDeque interceptorStack = null;
        boolean counted = false;
        boolean countsEnabled = this.isCountsEnabled();
        try {
            if (this.isLoggingEnabled() && this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("preReceive on channel '" + (Object)((Object)this) + "'"));
            }
            if (interceptorList.getInterceptors().size() > 0 && !interceptorList.preReceive((MessageChannel)this, interceptorStack = new ArrayDeque())) {
                return null;
            }
            Object object = this.messageSelector == null ? this.getJmsTemplate().receiveAndConvert() : this.getJmsTemplate().receiveSelectedAndConvert(this.messageSelector);
            Message message = null;
            if (object == null) {
                if (this.isLoggingEnabled() && this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("postReceive on channel '" + (Object)((Object)this) + "', message is null"));
                }
            } else {
                if (countsEnabled) {
                    if (this.getMetricsCaptor() != null) {
                        this.incrementReceiveCounter();
                    }
                    this.getMetrics().afterReceive();
                    counted = true;
                }
                message = object instanceof Message ? (Message)object : this.getMessageBuilderFactory().withPayload(object).build();
                if (this.isLoggingEnabled() && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("postReceive on channel '" + (Object)((Object)this) + "', message: " + message));
                }
            }
            if (interceptorStack != null) {
                if (message != null) {
                    message = interceptorList.postReceive(message, (MessageChannel)this);
                }
                interceptorList.afterReceiveCompletion(message, (MessageChannel)this, null, interceptorStack);
            }
            return message;
        }
        catch (RuntimeException e) {
            if (countsEnabled && !counted) {
                if (this.getMetricsCaptor() != null) {
                    CounterFacade counterFacade = this.getMetricsCaptor().counterBuilder("spring.integration.receive").tag("name", this.getComponentName() == null ? "unknown" : this.getComponentName()).tag("type", "channel").tag("result", "failure").tag("exception", e.getClass().getSimpleName()).description("Messages received").build();
                    this.meters.add(counterFacade);
                    counterFacade.increment();
                }
                this.getMetrics().afterError();
            }
            if (interceptorStack != null) {
                interceptorList.afterReceiveCompletion(null, (MessageChannel)this, (Exception)e, interceptorStack);
            }
            throw e;
        }
    }

    private void incrementReceiveCounter() {
        if (this.receiveCounter == null) {
            this.receiveCounter = this.getMetricsCaptor().counterBuilder("spring.integration.receive").tag("name", this.getComponentName()).tag("type", "channel").tag("result", "success").tag("exception", "none").description("Messages received").build();
            this.meters.add(this.receiveCounter);
        }
        this.receiveCounter.increment();
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        super.setInterceptors(interceptors);
        for (ChannelInterceptor interceptor : interceptors) {
            if (!(interceptor instanceof ExecutorChannelInterceptor)) continue;
            ++this.executorInterceptorsSize;
        }
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        super.addInterceptor(interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    public void addInterceptor(int index, ChannelInterceptor interceptor) {
        super.addInterceptor(index, interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    public boolean removeInterceptor(ChannelInterceptor interceptor) {
        boolean removed = super.removeInterceptor(interceptor);
        if (removed && interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return removed;
    }

    public ChannelInterceptor removeInterceptor(int index) {
        ChannelInterceptor interceptor = super.removeInterceptor(index);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return interceptor;
    }

    public boolean hasExecutorInterceptors() {
        return this.executorInterceptorsSize > 0;
    }
}

