/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jms.JmsOutboundGateway;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JmsOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        Element container;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JmsOutboundGateway.class);
        builder.addPropertyReference("connectionFactory", element.getAttribute("connection-factory"));
        this.parseDestination(element, parserContext, builder, "request-destination", "request-destination-name", "request-destination-expression", "requestDestination", "requestDestinationName", "requestDestinationExpression", true);
        this.parseDestination(element, parserContext, builder, "reply-destination", "reply-destination-name", "reply-destination-expression", "replyDestination", "replyDestinationName", "replyDestinationExpression", false);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"correlation-key");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"header-mapper");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"destination-resolver");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-request-payload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-reply-payload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-pub-sub-domain");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-pub-sub-domain");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"time-to-live");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"priority");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"explicit-qos-enabled");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"requires-reply");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"idle-reply-listener-timeout", (String)"idleReplyContainerTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"async");
        String deliveryPersistent = element.getAttribute("delivery-persistent");
        if (StringUtils.hasText((String)deliveryPersistent)) {
            builder.addPropertyValue("deliveryPersistent", (Object)deliveryPersistent);
        }
        if ((container = DomUtils.getChildElementByTagName((Element)element, (String)"reply-listener")) != null) {
            this.parseReplyContainer(builder, parserContext, container);
        }
        return builder;
    }

    private void parseDestination(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String destinationAttributeName, String destinationNameAttributeName, String destinationExpressionAttributeName, String destinationProperty, String destinationNameProperty, String destinationExpressionProperty, boolean oneRequired) {
        String destinationAttribute = element.getAttribute(destinationAttributeName);
        String destinationNameAttribute = element.getAttribute(destinationNameAttributeName);
        String destinationExpressionAttribute = element.getAttribute(destinationExpressionAttributeName);
        boolean hasDestination = StringUtils.hasText((String)destinationAttribute);
        boolean hasDestinationName = StringUtils.hasText((String)destinationNameAttribute);
        boolean hasDestinationExpression = StringUtils.hasText((String)destinationExpressionAttribute);
        int destCount = (hasDestination ? 1 : 0) + (hasDestinationName ? 1 : 0) + (hasDestinationExpression ? 1 : 0);
        if (oneRequired) {
            if (destCount != 1) {
                parserContext.getReaderContext().error("Exactly one of the '" + destinationAttribute + "', " + "'" + destinationNameAttributeName + "', or '" + destinationExpressionAttributeName + "' attributes is required.", (Object)element);
            }
        } else if (destCount > 1) {
            parserContext.getReaderContext().error("Only one of the '" + destinationAttribute + "', " + "'" + destinationNameAttributeName + "', or '" + destinationExpressionAttributeName + "' attributes is allowed.", (Object)element);
        }
        if (hasDestination) {
            builder.addPropertyReference(destinationProperty, destinationAttribute);
        } else if (hasDestinationName) {
            builder.addPropertyValue(destinationNameProperty, (Object)destinationNameAttribute);
        } else if (hasDestinationExpression) {
            BeanDefinitionBuilder expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            expressionBuilder.addConstructorArgValue((Object)destinationExpressionAttribute);
            builder.addPropertyValue(destinationExpressionProperty, (Object)expressionBuilder.getBeanDefinition());
        }
    }

    private void parseReplyContainer(BeanDefinitionBuilder gatewayBuilder, ParserContext parserContext, Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JmsOutboundGateway.ReplyContainerProperties.class);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"acknowledge", (String)"sessionAcknowledgeModeName");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"concurrent-consumers");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-concurrent-consumers");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-messages-per-task");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"recovery-interval");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"idle-consumer-limit");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"idle-task-execution-limit");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"cache-level");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        gatewayBuilder.addPropertyValue("replyContainerProperties", (Object)builder.getBeanDefinition());
    }
}

