/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.util.JmsAdapterUtils;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.util.Assert;

public class JmsMessageDrivenEndpoint
extends AbstractEndpoint
implements DisposableBean,
OrderlyShutdownCapable {
    private final AbstractMessageListenerContainer listenerContainer;
    private final boolean externalContainer;
    private final ChannelPublishingJmsMessageListener listener;
    private volatile String sessionAcknowledgeMode;

    public JmsMessageDrivenEndpoint(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener) {
        this(listenerContainer, listener, true);
    }

    private JmsMessageDrivenEndpoint(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener, boolean externalContainer) {
        Assert.notNull((Object)listenerContainer, (String)"listener container must not be null");
        Assert.notNull((Object)listener, (String)"listener must not be null");
        if (this.logger.isWarnEnabled() && listenerContainer.getMessageListener() != null) {
            this.logger.warn((Object)"The provided listener container already has a MessageListener implementation, but it will be overridden by the provided ChannelPublishingJmsMessageListener.");
        }
        listenerContainer.setMessageListener((Object)listener);
        this.listener = listener;
        this.listenerContainer = listenerContainer;
        this.setPhase(0x3FFFFFFF);
        this.externalContainer = externalContainer;
    }

    public void setSessionAcknowledgeMode(String sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
    }

    public String getComponentType() {
        return "jms:message-driven-channel-adapter";
    }

    protected void onInit() throws Exception {
        Integer acknowledgeMode;
        String sessionAcknowledgeMode;
        this.listener.afterPropertiesSet();
        if (!this.listenerContainer.isActive()) {
            this.listenerContainer.afterPropertiesSet();
        }
        if ((sessionAcknowledgeMode = this.sessionAcknowledgeMode) == null && !this.externalContainer && DefaultMessageListenerContainer.class.isAssignableFrom(this.listenerContainer.getClass())) {
            sessionAcknowledgeMode = "transacted";
        }
        if ((acknowledgeMode = JmsAdapterUtils.parseAcknowledgeMode(sessionAcknowledgeMode)) != null) {
            if (acknowledgeMode == 0) {
                this.listenerContainer.setSessionTransacted(true);
            } else {
                this.listenerContainer.setSessionAcknowledgeMode(acknowledgeMode.intValue());
            }
        }
        this.listener.setComponentName(this.getComponentName());
    }

    protected void doStart() {
        this.listener.start();
        if (!this.listenerContainer.isRunning()) {
            this.listenerContainer.start();
        }
    }

    protected void doStop() {
        this.listenerContainer.stop();
        this.listener.stop();
    }

    public void destroy() throws Exception {
        if (this.isRunning()) {
            this.stop();
        }
        this.listenerContainer.destroy();
    }

    public int beforeShutdown() {
        this.stop();
        return 0;
    }

    public int afterShutdown() {
        return 0;
    }
}

