/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.BroadcastingDispatcher;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.dispatcher.RoundRobinLoadBalancingStrategy;
import org.springframework.integration.dispatcher.UnicastingDispatcher;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.util.Assert;

public class SubscribableJmsChannel
extends AbstractJmsChannel
implements SubscribableChannel,
SmartLifecycle,
DisposableBean {
    private final AbstractMessageListenerContainer container;
    private volatile AbstractDispatcher dispatcher;
    private volatile boolean initialized;
    private volatile Integer maxSubscribers;

    public SubscribableJmsChannel(AbstractMessageListenerContainer container, JmsTemplate jmsTemplate) {
        super(jmsTemplate);
        Assert.notNull((Object)container, (String)"container must not be null");
        this.container = container;
    }

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
    }

    public boolean subscribe(MessageHandler handler) {
        Assert.state((this.dispatcher != null ? 1 : 0) != 0, (String)"'MessageDispatcher' must not be null. This channel might not have been initialized");
        return this.dispatcher.addHandler(handler);
    }

    public boolean unsubscribe(MessageHandler handler) {
        Assert.state((this.dispatcher != null ? 1 : 0) != 0, (String)"'MessageDispatcher' must not be null. This channel might not have been initialized");
        return this.dispatcher.removeHandler(handler);
    }

    public void onInit() throws Exception {
        if (this.initialized) {
            return;
        }
        super.onInit();
        boolean isPubSub = this.container.isPubSubDomain();
        this.configureDispatcher(isPubSub);
        DispatchingMessageListener listener = new DispatchingMessageListener(this.getJmsTemplate(), (MessageDispatcher)this.dispatcher, this, isPubSub);
        this.container.setMessageListener((Object)listener);
        if (!this.container.isActive()) {
            this.container.afterPropertiesSet();
        }
        this.initialized = true;
    }

    private void configureDispatcher(boolean isPubSub) {
        if (isPubSub) {
            this.dispatcher = new BroadcastingDispatcher(true);
        } else {
            UnicastingDispatcher unicastingDispatcher = new UnicastingDispatcher();
            unicastingDispatcher.setLoadBalancingStrategy((LoadBalancingStrategy)new RoundRobinLoadBalancingStrategy());
            this.dispatcher = unicastingDispatcher;
        }
        if (this.maxSubscribers == null) {
            this.maxSubscribers = (Integer)this.getIntegrationProperty(isPubSub ? "channels.maxBroadcastSubscribers" : "channels.maxUnicastSubscribers", Integer.class);
        }
        this.dispatcher.setMaxSubscribers(this.maxSubscribers.intValue());
    }

    public boolean isAutoStartup() {
        return this.container != null ? this.container.isAutoStartup() : false;
    }

    public int getPhase() {
        return this.container != null ? this.container.getPhase() : 0;
    }

    public boolean isRunning() {
        return this.container != null ? this.container.isRunning() : false;
    }

    public void start() {
        if (this.container != null) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.container != null) {
            this.container.stop(callback);
        }
    }

    public void destroy() throws Exception {
        if (this.container != null) {
            this.container.destroy();
        }
    }

    private static class DispatchingMessageListener
    implements MessageListener {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final JmsTemplate jmsTemplate;
        private final MessageDispatcher dispatcher;
        private final SubscribableJmsChannel channel;
        private final boolean isPubSub;

        private DispatchingMessageListener(JmsTemplate jmsTemplate, MessageDispatcher dispatcher, SubscribableJmsChannel channel, boolean isPubSub) {
            this.jmsTemplate = jmsTemplate;
            this.dispatcher = dispatcher;
            this.channel = channel;
            this.isPubSub = isPubSub;
        }

        public void onMessage(javax.jms.Message message) {
            Message messageToSend = null;
            try {
                Object converted = this.jmsTemplate.getMessageConverter().fromMessage(message);
                if (converted != null) {
                    messageToSend = converted instanceof Message ? (Message)converted : MessageBuilder.withPayload((Object)converted).build();
                    this.dispatcher.dispatch(messageToSend);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"MessageConverter returned null, no Message to dispatch");
                }
            }
            catch (MessageDispatchingException e) {
                String exceptionMessage = e.getMessage() + " for jms-channel '" + this.channel.getFullChannelName() + "'.";
                if (this.isPubSub) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)exceptionMessage, (Throwable)e);
                    }
                }
                throw new MessageDeliveryException(messageToSend, exceptionMessage, (Throwable)e);
            }
            catch (Exception e) {
                throw new MessagingException("failed to handle incoming JMS Message", (Throwable)e);
            }
        }
    }
}

