/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jms.core.JmsTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollableJmsChannel
extends AbstractJmsChannel
implements PollableChannel {
    public PollableJmsChannel(JmsTemplate jmsTemplate) {
        super(jmsTemplate);
    }

    public Message<?> receive() {
        if (!this.getInterceptors().preReceive((MessageChannel)this)) {
            return null;
        }
        Object object = this.getJmsTemplate().receiveAndConvert();
        if (object == null) {
            return null;
        }
        Message replyMessage = null;
        replyMessage = object instanceof Message ? (Message)object : MessageBuilder.withPayload((Object)object).build();
        return this.getInterceptors().postReceive(replyMessage, (MessageChannel)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<?> receive(long timeout) {
        try {
            DynamicJmsTemplateProperties.setReceiveTimeout(timeout);
            Message<?> message = this.receive();
            return message;
        }
        finally {
            DynamicJmsTemplateProperties.clearReceiveTimeout();
        }
    }
}

