/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.metadata;

import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class JdbcMetadataStore
implements ConcurrentMetadataStore,
InitializingBean {
    private static final String KEY_CANNOT_BE_NULL = "'key' cannot be null";
    public static final String DEFAULT_TABLE_PREFIX = "INT_";
    private final JdbcOperations jdbcTemplate;
    private String tablePrefix = "INT_";
    private String region = "DEFAULT";
    private String lockHint = "FOR UPDATE";
    private String getValueQuery = "SELECT METADATA_VALUE FROM %sMETADATA_STORE\nWHERE METADATA_KEY=? AND REGION=?\n";
    private String getValueForUpdateQuery = "SELECT METADATA_VALUE FROM %sMETADATA_STORE\nWHERE METADATA_KEY=? AND REGION=? %s\n";
    private String replaceValueQuery = "UPDATE %sMETADATA_STORE\nSET METADATA_VALUE=?\nWHERE METADATA_KEY=? AND METADATA_VALUE=? AND REGION=?\n";
    private String replaceValueByKeyQuery = "UPDATE %sMETADATA_STORE\nSET METADATA_VALUE=?\nWHERE METADATA_KEY=? AND REGION=?\n";
    private String removeValueQuery = "DELETE FROM %sMETADATA_STORE\nWHERE METADATA_KEY=? AND REGION=?\n";
    private String putIfAbsentValueQuery = "INSERT INTO %sMETADATA_STORE(METADATA_KEY, METADATA_VALUE, REGION)\nSELECT ?, ?, ?\n\tFROM %sMETADATA_STORE\n\tWHERE METADATA_KEY=? AND REGION=?\nHAVING COUNT(*)=0\n";

    public JdbcMetadataStore(DataSource dataSource) {
        this((JdbcOperations)new JdbcTemplate(dataSource));
    }

    public JdbcMetadataStore(JdbcOperations jdbcOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"'jdbcOperations' must not be null.");
        this.jdbcTemplate = jdbcOperations;
    }

    public void setTablePrefix(String tablePrefix) {
        Assert.notNull((Object)tablePrefix, (String)"'tablePrefix' must not be null.");
        this.tablePrefix = tablePrefix;
    }

    public void setRegion(String region) {
        Assert.hasText((String)region, (String)"'region' must not be null or empty.");
        this.region = region;
    }

    public void setLockHint(String lockHint) {
        Assert.notNull((Object)lockHint, (String)"'lockHint' cannot be null.");
        this.lockHint = lockHint;
    }

    public void afterPropertiesSet() {
        this.getValueQuery = String.format(this.getValueQuery, this.tablePrefix);
        this.getValueForUpdateQuery = String.format(this.getValueForUpdateQuery, this.tablePrefix, this.lockHint);
        this.replaceValueQuery = String.format(this.replaceValueQuery, this.tablePrefix);
        this.replaceValueByKeyQuery = String.format(this.replaceValueByKeyQuery, this.tablePrefix);
        this.removeValueQuery = String.format(this.removeValueQuery, this.tablePrefix);
        this.putIfAbsentValueQuery = String.format(this.putIfAbsentValueQuery, this.tablePrefix, this.tablePrefix);
    }

    @Transactional
    public String putIfAbsent(String key, String value) {
        Assert.notNull((Object)key, (String)KEY_CANNOT_BE_NULL);
        Assert.notNull((Object)value, (String)"'value' cannot be null");
        int affectedRows;
        while ((affectedRows = this.tryToPutIfAbsent(key, value)) <= 0) {
            try {
                return (String)this.jdbcTemplate.queryForObject(this.getValueQuery, String.class, new Object[]{key, this.region});
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                continue;
            }
            break;
        }
        return null;
    }

    private int tryToPutIfAbsent(String key, String value) {
        try {
            return this.jdbcTemplate.update(this.putIfAbsentValueQuery, ps -> {
                ps.setString(1, key);
                ps.setString(2, value);
                ps.setString(3, this.region);
                ps.setString(4, key);
                ps.setString(5, this.region);
            });
        }
        catch (DuplicateKeyException ex) {
            return 0;
        }
    }

    @Transactional
    public boolean replace(String key, String oldValue, String newValue) {
        Assert.notNull((Object)key, (String)KEY_CANNOT_BE_NULL);
        Assert.notNull((Object)oldValue, (String)"'oldValue' cannot be null");
        Assert.notNull((Object)newValue, (String)"'newValue' cannot be null");
        int affectedRows = this.jdbcTemplate.update(this.replaceValueQuery, ps -> {
            ps.setString(1, newValue);
            ps.setString(2, key);
            ps.setString(3, oldValue);
            ps.setString(4, this.region);
        });
        return affectedRows > 0;
    }

    @Transactional
    public void put(String key, String value) {
        int affectedRows;
        Assert.notNull((Object)key, (String)KEY_CANNOT_BE_NULL);
        Assert.notNull((Object)value, (String)"'value' cannot be null");
        while ((affectedRows = this.tryToPutIfAbsent(key, value)) == 0) {
            try {
                this.jdbcTemplate.queryForObject(this.getValueForUpdateQuery, String.class, new Object[]{key, this.region});
            }
            catch (EmptyResultDataAccessException e) {
                continue;
            }
            this.jdbcTemplate.update(this.replaceValueByKeyQuery, ps -> {
                ps.setString(1, value);
                ps.setString(2, key);
                ps.setString(3, this.region);
            });
            break;
        }
    }

    @Transactional
    public String get(String key) {
        Assert.notNull((Object)key, (String)KEY_CANNOT_BE_NULL);
        try {
            return (String)this.jdbcTemplate.queryForObject(this.getValueQuery, String.class, new Object[]{key, this.region});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Transactional
    public String remove(String key) {
        String oldValue;
        Assert.notNull((Object)key, (String)KEY_CANNOT_BE_NULL);
        try {
            oldValue = (String)this.jdbcTemplate.queryForObject(this.getValueForUpdateQuery, String.class, new Object[]{key, this.region});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        int updated = this.jdbcTemplate.update(this.removeValueQuery, new Object[]{key, this.region});
        if (updated != 0) {
            return oldValue;
        }
        return null;
    }
}

