/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.lock;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.integration.jdbc.lock.LockRepository;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class DefaultLockRepository
implements LockRepository,
InitializingBean,
ApplicationContextAware,
SmartInitializingSingleton {
    public static final String DEFAULT_TABLE_PREFIX = "INT_";
    public static final int DEFAULT_TTL = 10000;
    private final String id;
    private final JdbcTemplate template;
    private int ttl = 10000;
    private String prefix = "INT_";
    private String region = "DEFAULT";
    private String deleteQuery = "DELETE FROM %sLOCK WHERE REGION=? AND LOCK_KEY=? AND CLIENT_ID=?";
    private String deleteExpiredQuery = "DELETE FROM %sLOCK WHERE REGION=? AND CREATED_DATE<?";
    private String deleteAllQuery = "DELETE FROM %sLOCK WHERE REGION=? AND CLIENT_ID=?";
    private String updateQuery = "UPDATE %sLOCK SET CLIENT_ID=?, CREATED_DATE=? WHERE REGION=? AND LOCK_KEY=? AND (CLIENT_ID=? OR CREATED_DATE<?)";
    private String insertQuery = "INSERT INTO %sLOCK (REGION, LOCK_KEY, CLIENT_ID, CREATED_DATE) VALUES (?, ?, ?, ?)";
    private String countQuery = "SELECT COUNT(REGION) FROM %sLOCK WHERE REGION=? AND LOCK_KEY=? AND CLIENT_ID=? AND CREATED_DATE>=?";
    private String renewQuery = "UPDATE %sLOCK SET CREATED_DATE=? WHERE REGION=? AND LOCK_KEY=? AND CLIENT_ID=?";
    private ApplicationContext applicationContext;
    private PlatformTransactionManager transactionManager;
    private TransactionTemplate defaultTransactionTemplate;
    private TransactionTemplate readOnlyTransactionTemplate;
    private TransactionTemplate serializableTransactionTemplate;

    public DefaultLockRepository(DataSource dataSource) {
        this(dataSource, UUID.randomUUID().toString());
    }

    public DefaultLockRepository(DataSource dataSource, String id) {
        Assert.hasText((String)id, (String)"id must not be null nor empty");
        this.template = new JdbcTemplate(dataSource);
        this.id = id;
    }

    public void setRegion(String region) {
        Assert.hasText((String)region, (String)"Region must not be null or empty.");
        this.region = region;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setTimeToLive(int timeToLive) {
        this.ttl = timeToLive;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.deleteQuery = String.format(this.deleteQuery, this.prefix);
        this.deleteExpiredQuery = String.format(this.deleteExpiredQuery, this.prefix);
        this.deleteAllQuery = String.format(this.deleteAllQuery, this.prefix);
        this.updateQuery = String.format(this.updateQuery, this.prefix);
        this.insertQuery = String.format(this.insertQuery, this.prefix);
        this.countQuery = String.format(this.countQuery, this.prefix);
        this.renewQuery = String.format(this.renewQuery, this.prefix);
    }

    public void afterSingletonsInstantiated() {
        if (this.transactionManager == null) {
            try {
                this.transactionManager = (PlatformTransactionManager)this.applicationContext.getBean(PlatformTransactionManager.class);
            }
            catch (BeansException ex) {
                throw new BeanInitializationException("A unique or primary 'PlatformTransactionManager' bean must be present in the application context.", (Throwable)ex);
            }
        }
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
        this.defaultTransactionTemplate = new TransactionTemplate(this.transactionManager, (TransactionDefinition)transactionDefinition);
        transactionDefinition.setReadOnly(true);
        this.readOnlyTransactionTemplate = new TransactionTemplate(this.transactionManager, (TransactionDefinition)transactionDefinition);
        transactionDefinition.setReadOnly(false);
        transactionDefinition.setIsolationLevel(8);
        this.serializableTransactionTemplate = new TransactionTemplate(this.transactionManager, (TransactionDefinition)transactionDefinition);
    }

    @Override
    public void close() {
        this.defaultTransactionTemplate.executeWithoutResult(transactionStatus -> this.template.update(this.deleteAllQuery, new Object[]{this.region, this.id}));
    }

    @Override
    public void delete(String lock) {
        this.defaultTransactionTemplate.executeWithoutResult(transactionStatus -> this.template.update(this.deleteQuery, new Object[]{this.region, lock, this.id}));
    }

    @Override
    public boolean acquire(String lock) {
        Boolean result = (Boolean)this.serializableTransactionTemplate.execute(transactionStatus -> {
            if (this.template.update(this.updateQuery, new Object[]{this.id, LocalDateTime.now(ZoneOffset.UTC), this.region, lock, this.id, LocalDateTime.now(ZoneOffset.UTC).minus(this.ttl, ChronoUnit.MILLIS)}) > 0) {
                return true;
            }
            try {
                return this.template.update(this.insertQuery, new Object[]{this.region, lock, this.id, LocalDateTime.now(ZoneOffset.UTC)}) > 0;
            }
            catch (DataIntegrityViolationException ex) {
                return false;
            }
        });
        return Boolean.TRUE.equals(result);
    }

    @Override
    public boolean isAcquired(String lock) {
        Boolean result = (Boolean)this.readOnlyTransactionTemplate.execute(transactionStatus -> Integer.valueOf(1).equals(this.template.queryForObject(this.countQuery, Integer.class, new Object[]{this.region, lock, this.id, LocalDateTime.now(ZoneOffset.UTC).minus(this.ttl, ChronoUnit.MILLIS)})));
        return Boolean.TRUE.equals(result);
    }

    @Override
    public void deleteExpired() {
        this.defaultTransactionTemplate.executeWithoutResult(transactionStatus -> this.template.update(this.deleteExpiredQuery, new Object[]{this.region, LocalDateTime.now(ZoneOffset.UTC).minus(this.ttl, ChronoUnit.MILLIS)}));
    }

    @Override
    public boolean renew(String lock) {
        Boolean result = (Boolean)this.defaultTransactionTemplate.execute(transactionStatus -> this.template.update(this.renewQuery, new Object[]{LocalDateTime.now(ZoneOffset.UTC), this.region, lock, this.id}) > 0);
        return Boolean.TRUE.equals(result);
    }
}

