/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.ip.CommonSocketOptions;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.util.Assert;

public abstract class AbstractInternetProtocolSendingMessageHandler
extends AbstractMessageHandler
implements CommonSocketOptions,
ManageableLifecycle {
    private final Lock lock = new ReentrantLock();
    private final SocketAddress destinationAddress;
    private final String host;
    private final int port;
    private volatile int soSendBufferSize = -1;
    private volatile int soTimeout = -1;
    private volatile boolean running;

    public AbstractInternetProtocolSendingMessageHandler(String host, int port) {
        Assert.notNull((Object)host, (String)"host must not be null");
        this.destinationAddress = new InetSocketAddress(host, port);
        this.host = host;
        this.port = port;
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    @Override
    public void setSoReceiveBufferSize(int size) {
    }

    @Override
    public void setSoSendBufferSize(int size) {
        this.soSendBufferSize = size;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getSoSendBufferSize() {
        return this.soSendBufferSize;
    }

    public void start() {
        this.lock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void doStart();

    public void stop() {
        this.lock.lock();
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void doStop();

    public boolean isRunning() {
        return this.running;
    }
}

