/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.serializer.TcpDeserializationExceptionEvent;

public abstract class AbstractByteArraySerializer
implements Serializer<byte[]>,
Deserializer<byte[]>,
ApplicationEventPublisherAware {
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 2048;
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private int maxMessageSize = 2048;
    private ApplicationEventPublisher applicationEventPublisher;

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void checkClosure(int bite) throws IOException {
        if (bite < 0) {
            this.logger.debug((CharSequence)"Socket closed during message assembly");
            throw new IOException("Socket closed during message assembly");
        }
    }

    protected void publishEvent(Exception cause, byte[] buffer, int offset) {
        TcpDeserializationExceptionEvent event = new TcpDeserializationExceptionEvent(this, cause, buffer, offset);
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        } else {
            this.logger.trace(() -> "No event publisher for " + (Object)((Object)event));
        }
    }
}

