/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.springframework.integration.ip.udp.UnicastReceivingChannelAdapter;
import org.springframework.messaging.MessagingException;

public class MulticastReceivingChannelAdapter
extends UnicastReceivingChannelAdapter {
    private final String group;

    public MulticastReceivingChannelAdapter(String group, int port) {
        super(port);
        this.group = group;
    }

    public MulticastReceivingChannelAdapter(String group, int port, boolean lengthCheck) {
        super(port, lengthCheck);
        this.group = group;
    }

    @Override
    public synchronized DatagramSocket getSocket() {
        if (this.getTheSocket() == null) {
            try {
                int port = this.getPort();
                MulticastSocket socket = port == 0 ? new MulticastSocket() : new MulticastSocket(port);
                String localAddress = this.getLocalAddress();
                if (localAddress != null) {
                    InetAddress whichNic = InetAddress.getByName(localAddress);
                    socket.setInterface(whichNic);
                }
                this.setSocketAttributes(socket);
                socket.joinGroup(InetAddress.getByName(this.group));
                this.setSocket(socket);
            }
            catch (IOException e) {
                throw new MessagingException("failed to create DatagramSocket", (Throwable)e);
            }
        }
        return super.getSocket();
    }
}

