/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.dsl;

import java.net.DatagramSocket;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.ip.udp.UnicastSendingMessageHandler;
import org.springframework.messaging.Message;

public abstract class AbstractUdpOutboundChannelAdapterSpec<S extends AbstractUdpOutboundChannelAdapterSpec<S>>
extends MessageHandlerSpec<S, UnicastSendingMessageHandler> {
    protected AbstractUdpOutboundChannelAdapterSpec() {
    }

    protected AbstractUdpOutboundChannelAdapterSpec(String host, int port) {
        this.target = new UnicastSendingMessageHandler(host, port);
    }

    AbstractUdpOutboundChannelAdapterSpec(String destinationExpression) {
        this.target = new UnicastSendingMessageHandler(destinationExpression);
    }

    AbstractUdpOutboundChannelAdapterSpec(Function<Message<?>, ?> destinationFunction) {
        this.target = new UnicastSendingMessageHandler((Expression)new FunctionExpression(destinationFunction));
    }

    public S soTimeout(int timeout) {
        ((UnicastSendingMessageHandler)this.target).setSoTimeout(timeout);
        return (S)((Object)((AbstractUdpOutboundChannelAdapterSpec)this._this()));
    }

    public S soSendBufferSize(int size) {
        ((UnicastSendingMessageHandler)this.target).setSoSendBufferSize(size);
        return (S)((Object)((AbstractUdpOutboundChannelAdapterSpec)this._this()));
    }

    public S localAddress(String localAddress) {
        ((UnicastSendingMessageHandler)this.target).setLocalAddress(localAddress);
        return (S)((Object)((AbstractUdpOutboundChannelAdapterSpec)this._this()));
    }

    public S lengthCheck(boolean lengthCheck) {
        ((UnicastSendingMessageHandler)this.target).setLengthCheck(lengthCheck);
        return (S)((Object)((AbstractUdpOutboundChannelAdapterSpec)this._this()));
    }

    public S soReceiveBufferSize(int size) {
        ((UnicastSendingMessageHandler)this.target).setSoReceiveBufferSize(size);
        return (S)((Object)((AbstractUdpOutboundChannelAdapterSpec)this._this()));
    }

    public S ackCounter(int ackCounter) {
        ((UnicastSendingMessageHandler)this.target).setAckCounter(ackCounter);
        return (S)((Object)((AbstractUdpOutboundChannelAdapterSpec)this._this()));
    }

    public S socketFunction(Function<Message<?>, DatagramSocket> socketFunction) {
        ((UnicastSendingMessageHandler)this.target).setSocketExpression((Expression)new FunctionExpression(socketFunction));
        return (S)((Object)((AbstractUdpOutboundChannelAdapterSpec)this._this()));
    }

    public S socketExpression(String socketExpression) {
        ((UnicastSendingMessageHandler)this.target).setSocketExpressionString(socketExpression);
        return (S)((Object)((AbstractUdpOutboundChannelAdapterSpec)this._this()));
    }
}

