/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

public class ByteArrayRawSerializer
extends AbstractByteArraySerializer {
    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(bytes);
        outputStream.flush();
    }

    public byte[] deserialize(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[this.maxMessageSize];
        int n = 0;
        int bite = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Available to read:" + inputStream.available()));
        }
        while (bite >= 0) {
            bite = inputStream.read();
            if (bite < 0) {
                if (n != 0) break;
                throw new SoftEndOfStreamException("Stream closed between payloads");
            }
            buffer[n++] = (byte)bite;
            if (n < this.maxMessageSize) continue;
            throw new IOException("Socket was not closed before max message length: " + this.maxMessageSize);
        }
        byte[] assembledData = new byte[n];
        System.arraycopy(buffer, 0, assembledData, 0, n);
        return assembledData;
    }
}

