/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.Message;
import org.springframework.integration.ip.tcp.connection.NoListenerException;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

public class TcpNetConnection
extends TcpConnectionSupport {
    private final Socket socket;
    private volatile long lastRead = System.currentTimeMillis();
    private volatile long lastSend;

    @Deprecated
    public TcpNetConnection(Socket socket, boolean server, boolean lookupHost) {
        this(socket, server, lookupHost, null, null);
    }

    public TcpNetConnection(Socket socket, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName) {
        super(socket, server, lookupHost, applicationEventPublisher, connectionFactoryName);
        this.socket = socket;
    }

    @Override
    public void close() {
        this.setNoReadErrorOnClose(true);
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public synchronized void send(Message<?> message) throws Exception {
        Object object = this.getMapper().fromMessage(message);
        this.lastSend = System.currentTimeMillis();
        try {
            this.getSerializer().serialize(object, this.socket.getOutputStream());
        }
        catch (Exception e) {
            this.publishConnectionExceptionEvent(e);
            this.closeConnection(true);
            throw e;
        }
        this.afterSend(message);
    }

    @Override
    public Object getPayload() throws Exception {
        return this.getDeserializer().deserialize(this.socket.getInputStream());
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public Object getDeserializerStateKey() {
        try {
            return this.socket.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void run() {
        boolean singleUse = this.isSingleUse();
        TcpListener listener = this.getListener();
        if (listener == null && !singleUse) {
            this.logger.debug((Object)"TcpListener exiting - no listener and not single use");
            return;
        }
        boolean okToRun = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getConnectionId() + " Reading..."));
        }
        boolean intercepted = false;
        while (okToRun) {
            Message<Object> message;
            block12: {
                message = null;
                try {
                    message = this.getMapper().toMessage(this);
                    this.lastRead = System.currentTimeMillis();
                }
                catch (Exception e) {
                    this.publishConnectionExceptionEvent(e);
                    if (!this.handleReadException(e)) break block12;
                    okToRun = false;
                }
            }
            if (!okToRun || message == null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received " + message));
            }
            try {
                if (listener == null) {
                    this.logger.warn((Object)("Unexpected message - no inbound adapter registered with connection " + message));
                    continue;
                }
                intercepted = this.getListener().onMessage(message);
            }
            catch (NoListenerException nle) {
                if (singleUse) {
                    this.logger.debug((Object)("Closing single use socket after inbound message " + this.getConnectionId()));
                    this.closeConnection(true);
                    okToRun = false;
                } else {
                    this.logger.warn((Object)("Unexpected message - no inbound adapter registered with connection " + message));
                }
            }
            catch (Exception e2) {
                this.logger.error((Object)("Exception sending message: " + message), (Throwable)e2);
            }
            if (!singleUse || (this.isServer() || intercepted) && (!this.isServer() || this.getSender() != null)) continue;
            this.logger.debug((Object)("Closing single use socket after inbound message " + this.getConnectionId()));
            this.closeConnection(false);
            okToRun = false;
        }
    }

    protected boolean handleReadException(Exception e) {
        boolean doClose = true;
        if (!this.isServer() && e instanceof SocketTimeoutException) {
            long now = System.currentTimeMillis();
            try {
                int soTimeout = this.socket.getSoTimeout();
                if (now - this.lastSend < (long)soTimeout && now - this.lastRead < (long)(soTimeout * 2)) {
                    doClose = false;
                }
                if (!doClose && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Skipping a socket timeout because we have a recent send " + this.getConnectionId()));
                }
            }
            catch (SocketException e1) {
                this.logger.error((Object)"Error accessing soTimeout", (Throwable)e1);
            }
        }
        if (doClose) {
            boolean noReadErrorOnClose = this.isNoReadErrorOnClose();
            this.closeConnection(true);
            if (!(e instanceof SoftEndOfStreamException)) {
                if (e instanceof SocketTimeoutException && this.isSingleUse()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Closed single use socket after timeout:" + this.getConnectionId()));
                    }
                } else {
                    if (noReadErrorOnClose) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("Read exception " + this.getConnectionId()), (Throwable)e);
                        } else if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Read exception " + this.getConnectionId() + " " + e.getClass().getSimpleName() + ":" + (e.getCause() != null ? e.getCause() + ":" : "") + e.getMessage()));
                        }
                    } else if (this.logger.isTraceEnabled()) {
                        this.logger.error((Object)("Read exception " + this.getConnectionId()), (Throwable)e);
                    } else {
                        this.logger.error((Object)("Read exception " + this.getConnectionId() + " " + e.getClass().getSimpleName() + ":" + (e.getCause() != null ? e.getCause() + ":" : "") + e.getMessage()));
                    }
                    this.sendExceptionToListener(e);
                }
            }
        }
        return doClose;
    }
}

