/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.util.Assert;

public abstract class AbstractServerConnectionFactory
extends AbstractConnectionFactory
implements Runnable,
OrderlyShutdownCapable {
    private static final int DEFAULT_BACKLOG = 5;
    private volatile boolean listening;
    private volatile String localAddress;
    private volatile int backlog = 5;
    private volatile boolean shuttingDown;

    public AbstractServerConnectionFactory(int port) {
        super(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isActive()) {
                this.setActive(true);
                this.shuttingDown = false;
                this.getTaskExecutor().execute(this);
            }
        }
        super.start();
    }

    @Override
    public TcpConnection getConnection() throws Exception {
        throw new UnsupportedOperationException("Getting a connection from a server factory is not supported");
    }

    protected void setListening(boolean listening) {
        this.listening = listening;
    }

    public boolean isListening() {
        return this.listening;
    }

    protected boolean isShuttingDown() {
        return this.shuttingDown;
    }

    protected void initializeConnection(TcpConnectionSupport connection, Socket socket) {
        TcpListener listener = this.getListener();
        if (listener != null) {
            connection.registerListener(listener);
        }
        connection.registerSender(this.getSender());
        connection.setMapper(this.getMapper());
        connection.setDeserializer(this.getDeserializer());
        connection.setSerializer(this.getSerializer());
        connection.setSingleUse(this.isSingleUse());
        if (this.isSingleUse() && this.getSoTimeout() < 0) {
            try {
                socket.setSoTimeout(10000);
            }
            catch (SocketException e) {
                this.logger.error((Object)"Error setting default reply timeout", (Throwable)e);
            }
        }
    }

    protected void postProcessServerSocket(ServerSocket serverSocket) {
        this.getTcpSocketSupport().postProcessServerSocket(serverSocket);
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        Assert.isTrue((backlog >= 0 ? 1 : 0) != 0, (String)"You cannot set backlog negative");
        this.backlog = backlog;
    }

    public int beforeShutdown() {
        this.shuttingDown = true;
        return 0;
    }

    public int afterShutdown() {
        this.stop();
        return 0;
    }
}

