/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.dsl;

import java.net.URI;
import java.util.Arrays;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.dsl.BaseHttpMessageHandlerSpec;
import org.springframework.integration.http.outbound.HttpRequestExecutingMessageHandler;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpMessageHandlerSpec
extends BaseHttpMessageHandlerSpec<HttpMessageHandlerSpec, HttpRequestExecutingMessageHandler> {
    private final RestTemplate restTemplate;

    HttpMessageHandlerSpec(URI uri, RestTemplate restTemplate) {
        this((Expression)new ValueExpression((Object)uri), restTemplate);
    }

    HttpMessageHandlerSpec(String uri, RestTemplate restTemplate) {
        this((Expression)new LiteralExpression(uri), restTemplate);
    }

    HttpMessageHandlerSpec(Expression uriExpression, RestTemplate restTemplate) {
        super(new HttpRequestExecutingMessageHandler(uriExpression, restTemplate));
        this.restTemplate = restTemplate;
    }

    public HttpMessageHandlerSpec requestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.isTrue((!this.isClientSet() ? 1 : 0) != 0, (String)"the 'requestFactory' must be specified on the provided 'restTemplate'");
        ((HttpRequestExecutingMessageHandler)((Object)this.target)).setRequestFactory(requestFactory);
        return this;
    }

    public HttpMessageHandlerSpec errorHandler(ResponseErrorHandler errorHandler) {
        Assert.isTrue((!this.isClientSet() ? 1 : 0) != 0, (String)"the 'errorHandler' must be specified on the provided 'restTemplate'");
        ((HttpRequestExecutingMessageHandler)((Object)this.target)).setErrorHandler(errorHandler);
        return (HttpMessageHandlerSpec)this._this();
    }

    public HttpMessageHandlerSpec messageConverters(HttpMessageConverter<?> ... messageConverters) {
        Assert.isTrue((!this.isClientSet() ? 1 : 0) != 0, (String)"the 'messageConverters' must be specified on the provided 'restTemplate'");
        ((HttpRequestExecutingMessageHandler)((Object)this.target)).setMessageConverters(Arrays.asList(messageConverters));
        return (HttpMessageHandlerSpec)this._this();
    }

    @Override
    protected boolean isClientSet() {
        return this.restTemplate != null;
    }
}

