/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class DefaultHttpHeaderMapper
implements HeaderMapper<HttpHeaders>,
BeanFactoryAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(DefaultHttpHeaderMapper.class);
    private volatile ConversionService conversionService;
    private volatile BeanFactory beanFactory;
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_CHARSET = "Accept-Charset";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ACCEPT_LANGUAGE = "Accept-Language";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String AGE = "Age";
    private static final String ALLOW = "Allow";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String CONNECTION = "Connection";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_LANGUAGE = "Content-Language";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_LOCATION = "Content-Location";
    private static final String CONTENT_MD5 = "Content-MD5";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String COOKIE = "Cookie";
    private static final String DATE = "Date";
    private static final String ETAG = "ETag";
    private static final String EXPECT = "Expect";
    private static final String EXPIRES = "Expires";
    private static final String FROM = "From";
    private static final String HOST = "Host";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_RANGE = "If-Range";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String LOCATION = "Location";
    private static final String MAX_FORWARDS = "Max-Forwards";
    private static final String PRAGMA = "Pragma";
    private static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final String RANGE = "Range";
    private static final String REFERER = "Referer";
    private static final String REFRESH = "Refresh";
    private static final String RETRY_AFTER = "Retry-After";
    private static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    private static final String TE = "TE";
    private static final String TRAILER = "Trailer";
    private static final String UPGRADE = "Upgrade";
    private static final String USER_AGENT = "User-Agent";
    private static final String VARY = "Vary";
    private static final String VIA = "Via";
    private static final String WARNING = "Warning";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String[] HTTP_REQUEST_HEADER_NAMES = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Authorization", "Cache-Control", "Connection", "Content-Length", "Content-Type", "Cookie", "Date", "Expect", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Max-Forwards", "Pragma", "Proxy-Authorization", "Range", "Referer", "TE", "Upgrade", "User-Agent", "Via", "Warning"};
    private static final Set<String> HTTP_REQUEST_HEADER_NAMES_LOWER = new HashSet<String>();
    private static final String[] HTTP_RESPONSE_HEADER_NAMES = new String[]{"Accept-Ranges", "Age", "Allow", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Content-Disposition", "Transfer-Encoding", "Date", "ETag", "Expires", "Last-Modified", "Location", "Pragma", "Proxy-Authenticate", "Refresh", "Retry-After", "Server", "Set-Cookie", "Trailer", "Vary", "Via", "Warning", "WWW-Authenticate"};
    private static final Set<String> HTTP_RESPONSE_HEADER_NAMES_LOWER = new HashSet<String>();
    private static final String[] HTTP_REQUEST_HEADER_NAMES_OUTBOUND_EXCLUSIONS = new String[0];
    private static final String[] HTTP_RESPONSE_HEADER_NAMES_INBOUND_EXCLUSIONS = new String[]{"Content-Length", "Transfer-Encoding"};
    public static final String HTTP_REQUEST_HEADER_NAME_PATTERN = "HTTP_REQUEST_HEADERS";
    public static final String HTTP_RESPONSE_HEADER_NAME_PATTERN = "HTTP_RESPONSE_HEADERS";
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy"};
    private static TimeZone GMT = TimeZone.getTimeZone("GMT");
    private volatile String[] outboundHeaderNames = new String[0];
    private volatile String[] outboundHeaderNamesLower = new String[0];
    private volatile String[] outboundHeaderNamesLowerWithContentType = new String[0];
    private volatile String[] inboundHeaderNames = new String[0];
    private volatile String[] inboundHeaderNamesLower = new String[0];
    private volatile String[] excludedOutboundStandardRequestHeaderNames = new String[0];
    private volatile String[] excludedInboundStandardResponseHeaderNames = new String[0];
    private volatile String userDefinedHeaderPrefix = "X-";
    private volatile boolean isDefaultOutboundMapper;
    private volatile boolean isDefaultInboundMapper;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setOutboundHeaderNames(String[] outboundHeaderNames) {
        if (HTTP_REQUEST_HEADER_NAMES == outboundHeaderNames) {
            this.isDefaultOutboundMapper = true;
        } else if (HTTP_RESPONSE_HEADER_NAMES == outboundHeaderNames) {
            this.isDefaultInboundMapper = true;
        }
        this.outboundHeaderNames = outboundHeaderNames != null ? Arrays.copyOf(outboundHeaderNames, outboundHeaderNames.length) : new String[]{};
        this.outboundHeaderNamesLower = new String[this.outboundHeaderNames.length];
        for (int i = 0; i < this.outboundHeaderNames.length; ++i) {
            this.outboundHeaderNamesLower[i] = HTTP_REQUEST_HEADER_NAME_PATTERN.equals(this.outboundHeaderNames[i]) || HTTP_RESPONSE_HEADER_NAME_PATTERN.equals(this.outboundHeaderNames[i]) ? this.outboundHeaderNames[i] : this.outboundHeaderNames[i].toLowerCase();
        }
        this.outboundHeaderNamesLowerWithContentType = Arrays.copyOf(this.outboundHeaderNamesLower, this.outboundHeaderNames.length + 1);
        this.outboundHeaderNamesLowerWithContentType[this.outboundHeaderNamesLowerWithContentType.length - 1] = "contentType".toLowerCase();
    }

    public void setInboundHeaderNames(String[] inboundHeaderNames) {
        this.inboundHeaderNames = inboundHeaderNames != null ? Arrays.copyOf(inboundHeaderNames, inboundHeaderNames.length) : new String[]{};
        this.inboundHeaderNamesLower = new String[this.inboundHeaderNames.length];
        for (int i = 0; i < this.inboundHeaderNames.length; ++i) {
            this.inboundHeaderNamesLower[i] = HTTP_REQUEST_HEADER_NAME_PATTERN.equals(this.inboundHeaderNames[i]) || HTTP_RESPONSE_HEADER_NAME_PATTERN.equals(this.inboundHeaderNames[i]) ? this.inboundHeaderNames[i] : this.inboundHeaderNames[i].toLowerCase();
        }
    }

    public void setExcludedOutboundStandardRequestHeaderNames(String[] excludedOutboundStandardRequestHeaderNames) {
        Assert.notNull((Object)excludedOutboundStandardRequestHeaderNames, (String)"'excludedOutboundStandardRequestHeaderNames' must not be null");
        this.excludedOutboundStandardRequestHeaderNames = Arrays.copyOf(excludedOutboundStandardRequestHeaderNames, excludedOutboundStandardRequestHeaderNames.length);
    }

    public void setExcludedInboundStandardResponseHeaderNames(String[] excludedInboundStandardResponseHeaderNames) {
        Assert.notNull((Object)excludedInboundStandardResponseHeaderNames, (String)"'excludedInboundStandardResponseHeaderNames' must not be null");
        this.excludedInboundStandardResponseHeaderNames = Arrays.copyOf(excludedInboundStandardResponseHeaderNames, excludedInboundStandardResponseHeaderNames.length);
    }

    public void setUserDefinedHeaderPrefix(String userDefinedHeaderPrefix) {
        this.userDefinedHeaderPrefix = userDefinedHeaderPrefix != null ? userDefinedHeaderPrefix : "";
    }

    public void fromHeaders(MessageHeaders headers, HttpHeaders target) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("outboundHeaderNames={0}", CollectionUtils.arrayToList((Object)this.outboundHeaderNames)));
        }
        for (Map.Entry entry : headers.entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            String lowerName = name.toLowerCase();
            if (!this.shouldMapOutboundHeader(lowerName) || (value = entry.getValue()) == null) continue;
            if (!(HTTP_REQUEST_HEADER_NAMES_LOWER.contains(lowerName) || HTTP_RESPONSE_HEADER_NAMES_LOWER.contains(lowerName) || "contentType".equalsIgnoreCase(name))) {
                String string = name = StringUtils.startsWithIgnoreCase((String)name, (String)this.userDefinedHeaderPrefix) ? name : this.userDefinedHeaderPrefix + name;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("setting headerName=[{0}], value={1}", name, value));
            }
            this.setHttpHeader(target, name, value);
        }
    }

    public Map<String, Object> toHeaders(HttpHeaders source) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("inboundHeaderNames={0}", CollectionUtils.arrayToList((Object)this.inboundHeaderNames)));
        }
        HashMap<String, Object> target = new HashMap<String, Object>();
        Set headerNames = source.keySet();
        for (String name : headerNames) {
            String lowerName = name.toLowerCase();
            if (!this.shouldMapInboundHeader(lowerName)) continue;
            if (!HTTP_REQUEST_HEADER_NAMES_LOWER.contains(lowerName) && !HTTP_RESPONSE_HEADER_NAMES_LOWER.contains(lowerName)) {
                String prefixedName = StringUtils.startsWithIgnoreCase((String)name, (String)this.userDefinedHeaderPrefix) ? name : this.userDefinedHeaderPrefix + name;
                Object value = source.containsKey((Object)prefixedName) ? this.getHttpHeader(source, prefixedName) : this.getHttpHeader(source, name);
                if (value == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("setting headerName=[{0}], value={1}", name, value));
                }
                this.setMessageHeader(target, name, value);
                continue;
            }
            Object value = this.getHttpHeader(source, name);
            if (value == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("setting headerName=[{0}], value={1}", name, value));
            }
            if (CONTENT_TYPE.equals(name)) {
                name = "contentType";
            }
            this.setMessageHeader(target, name, value);
        }
        return target;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.beanFactory != null) {
            this.conversionService = IntegrationUtils.getConversionService((BeanFactory)this.beanFactory);
        }
    }

    private boolean containsElementIgnoreCase(String[] headerNames, String name) {
        for (String headerName : headerNames) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldMapOutboundHeader(String headerName) {
        String[] outboundHeaderNamesLower = this.outboundHeaderNamesLowerWithContentType;
        if (this.isDefaultInboundMapper) {
            if (this.containsElementIgnoreCase(this.excludedInboundStandardResponseHeaderNames, headerName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped (excluded)", headerName));
                }
                return false;
            }
        } else if (this.isDefaultOutboundMapper) {
            outboundHeaderNamesLower = this.outboundHeaderNamesLowerWithContentType;
            if (this.containsElementIgnoreCase(this.excludedOutboundStandardRequestHeaderNames, headerName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped (excluded)", headerName));
                }
                return false;
            }
        }
        return this.shouldMapHeader(headerName, outboundHeaderNamesLower);
    }

    private boolean shouldMapInboundHeader(String headerName) {
        return this.shouldMapHeader(headerName, this.inboundHeaderNamesLower);
    }

    private boolean shouldMapHeader(String headerName, String[] patterns) {
        if (patterns != null && patterns.length > 0) {
            for (String pattern : patterns) {
                if (PatternMatchUtils.simpleMatch((String)pattern, (String)headerName)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                    }
                    return true;
                }
                if (HTTP_REQUEST_HEADER_NAME_PATTERN.equals(pattern) && HTTP_REQUEST_HEADER_NAMES_LOWER.contains(headerName)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                    }
                    return true;
                }
                if (!HTTP_RESPONSE_HEADER_NAME_PATTERN.equals(pattern) || !HTTP_RESPONSE_HEADER_NAMES_LOWER.contains(headerName)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                }
                return true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped", headerName));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setHttpHeader(HttpHeaders target, String name, Object value) {
        block100: {
            Object method2;
            block99: {
                Object[] values;
                block97: {
                    Object charset2;
                    block96: {
                        Object type2;
                        block94: {
                            block98: {
                                block95: {
                                    block93: {
                                        if (!ACCEPT.equalsIgnoreCase(name)) break block93;
                                        if (!(value instanceof Collection)) {
                                            if (value instanceof MediaType) {
                                                target.setAccept(Collections.singletonList((MediaType)value));
                                                return;
                                            }
                                            if (value instanceof String[]) {
                                                ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
                                                String[] acceptableMediaTypes2 = (String[])value;
                                                int n = acceptableMediaTypes2.length;
                                                int type2 = 0;
                                                while (true) {
                                                    if (type2 >= n) {
                                                        target.setAccept(acceptableMediaTypes);
                                                        return;
                                                    }
                                                    String next = acceptableMediaTypes2[type2];
                                                    acceptableMediaTypes.add(MediaType.parseMediaType((String)next));
                                                    ++type2;
                                                }
                                            }
                                            if (value instanceof String) {
                                                target.setAccept(MediaType.parseMediaTypes((String)((String)value)));
                                                return;
                                            }
                                            Class<?> clazz = value != null ? value.getClass() : null;
                                            throw new IllegalArgumentException("Expected MediaType or String value for 'Accept' header value, but received: " + clazz);
                                        }
                                        break block94;
                                    }
                                    if (!ACCEPT_CHARSET.equalsIgnoreCase(name)) break block95;
                                    if (value instanceof Collection) break block96;
                                    if (!(value instanceof Charset[]) && !(value instanceof String[])) {
                                        if (value instanceof Charset) {
                                            target.setAcceptCharset(Collections.singletonList((Charset)value));
                                            return;
                                        }
                                        if (value instanceof String) {
                                            String[] charsets = StringUtils.commaDelimitedListToStringArray((String)((String)value));
                                            ArrayList<Charset> acceptableCharsets = new ArrayList<Charset>();
                                            String[] stringArray = charsets;
                                            int charset2 = stringArray.length;
                                            int clazz = 0;
                                            while (true) {
                                                if (clazz >= charset2) {
                                                    target.setAcceptCharset(acceptableCharsets);
                                                    return;
                                                }
                                                String charset3 = stringArray[clazz];
                                                acceptableCharsets.add(Charset.forName(charset3.trim()));
                                                ++clazz;
                                            }
                                        }
                                        Class<?> clazz = value != null ? value.getClass() : null;
                                        throw new IllegalArgumentException("Expected Charset or String value for 'Accept-Charset' header value, but received: " + clazz);
                                    }
                                    break block97;
                                }
                                if (!ALLOW.equalsIgnoreCase(name)) break block98;
                                if (!(value instanceof Collection)) {
                                    if (value instanceof HttpMethod) {
                                        target.setAllow(Collections.singleton((HttpMethod)value));
                                        return;
                                    }
                                    if (value instanceof HttpMethod[]) {
                                        HashSet allowedMethods = new HashSet();
                                        Collections.addAll(allowedMethods, (HttpMethod[])value);
                                        target.setAllow(allowedMethods);
                                        return;
                                    }
                                    if (value instanceof String || value instanceof String[]) {
                                        String[] values2 = value instanceof String[] ? (String[])value : StringUtils.commaDelimitedListToStringArray((String)((String)value));
                                        HashSet<HttpMethod> allowedMethods = new HashSet<HttpMethod>();
                                        String[] stringArray = values2;
                                        int method2 = stringArray.length;
                                        int clazz = 0;
                                        while (true) {
                                            if (clazz >= method2) {
                                                target.setAllow(allowedMethods);
                                                return;
                                            }
                                            String next = stringArray[clazz];
                                            allowedMethods.add(HttpMethod.valueOf((String)next.trim()));
                                            ++clazz;
                                        }
                                    }
                                    Class<?> clazz = value != null ? value.getClass() : null;
                                    throw new IllegalArgumentException("Expected HttpMethod or String value for 'Allow' header value, but received: " + clazz);
                                }
                                break block99;
                            }
                            if (CACHE_CONTROL.equalsIgnoreCase(name)) {
                                if (value instanceof String) {
                                    target.setCacheControl((String)value);
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected String value for 'Cache-Control' header value, but received: " + clazz);
                            }
                            if (CONTENT_LENGTH.equalsIgnoreCase(name)) {
                                if (value instanceof Number) {
                                    target.setContentLength(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    target.setContentLength(Long.parseLong((String)value));
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Number or String value for 'Content-Length' header value, but received: " + clazz);
                            }
                            if ("contentType".equalsIgnoreCase(name)) {
                                if (value instanceof MediaType) {
                                    target.setContentType((MediaType)value);
                                    return;
                                }
                                if (value instanceof String) {
                                    target.setContentType(MediaType.parseMediaType((String)((String)value)));
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected MediaType or String value for 'Content-Type' header value, but received: " + clazz);
                            }
                            if (DATE.equalsIgnoreCase(name)) {
                                if (value instanceof Date) {
                                    target.setDate(((Date)value).getTime());
                                    return;
                                }
                                if (value instanceof Number) {
                                    target.setDate(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    try {
                                        target.setDate(Long.parseLong((String)value));
                                        return;
                                    }
                                    catch (NumberFormatException e) {
                                        target.setDate(this.getFirstDate((String)value, DATE));
                                        return;
                                    }
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Date, Number, or String value for 'Date' header value, but received: " + clazz);
                            }
                            if (ETAG.equalsIgnoreCase(name)) {
                                if (value instanceof String) {
                                    target.setETag((String)value);
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected String value for 'ETag' header value, but received: " + clazz);
                            }
                            if (EXPIRES.equalsIgnoreCase(name)) {
                                if (value instanceof Date) {
                                    target.setExpires(((Date)value).getTime());
                                    return;
                                }
                                if (value instanceof Number) {
                                    target.setExpires(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    try {
                                        target.setExpires(Long.parseLong((String)value));
                                        return;
                                    }
                                    catch (NumberFormatException e) {
                                        target.setExpires(this.getFirstDate((String)value, EXPIRES));
                                        return;
                                    }
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Date, Number, or String value for 'Expires' header value, but received: " + clazz);
                            }
                            if (IF_MODIFIED_SINCE.equalsIgnoreCase(name)) {
                                if (value instanceof Date) {
                                    target.setIfModifiedSince(((Date)value).getTime());
                                    return;
                                }
                                if (value instanceof Number) {
                                    target.setIfModifiedSince(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    try {
                                        target.setIfModifiedSince(Long.parseLong((String)value));
                                        return;
                                    }
                                    catch (NumberFormatException e) {
                                        target.setIfModifiedSince(this.getFirstDate((String)value, IF_MODIFIED_SINCE));
                                        return;
                                    }
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Date, Number, or String value for 'If-Modified-Since' header value, but received: " + clazz);
                            }
                            if (IF_UNMODIFIED_SINCE.equalsIgnoreCase(name)) {
                                String ifUnmodifiedSinceValue = null;
                                if (value instanceof Date) {
                                    ifUnmodifiedSinceValue = this.formatDate(((Date)value).getTime());
                                } else if (value instanceof Number) {
                                    ifUnmodifiedSinceValue = this.formatDate(((Number)value).longValue());
                                } else if (value instanceof String) {
                                    try {
                                        ifUnmodifiedSinceValue = this.formatDate(Long.parseLong((String)value));
                                    }
                                    catch (NumberFormatException e) {
                                        long longValue = this.getFirstDate((String)value, IF_UNMODIFIED_SINCE);
                                        ifUnmodifiedSinceValue = this.formatDate(longValue);
                                    }
                                } else {
                                    Class<?> clazz = value != null ? value.getClass() : null;
                                    throw new IllegalArgumentException("Expected Date, Number, or String value for 'If-Unmodified-Since' header value, but received: " + clazz);
                                }
                                target.set(IF_UNMODIFIED_SINCE, ifUnmodifiedSinceValue);
                                return;
                            }
                            if (IF_NONE_MATCH.equalsIgnoreCase(name)) {
                                Object next;
                                if (value instanceof String) {
                                    target.setIfNoneMatch((String)value);
                                    return;
                                }
                                if (value instanceof String[]) {
                                    String delmitedString = StringUtils.arrayToCommaDelimitedString((Object[])((String[])value));
                                    target.setIfNoneMatch(delmitedString);
                                    return;
                                }
                                if (!(value instanceof Collection)) return;
                                Collection values3 = (Collection)value;
                                if (CollectionUtils.isEmpty((Collection)values3)) return;
                                ArrayList<String> ifNoneMatchList = new ArrayList<String>();
                                Iterator longValue = values3.iterator();
                                while (true) {
                                    if (!longValue.hasNext()) {
                                        target.setIfNoneMatch(ifNoneMatchList);
                                        return;
                                    }
                                    next = longValue.next();
                                    if (!(next instanceof String)) break;
                                    ifNoneMatchList.add((String)next);
                                }
                                Class<?> clazz = next != null ? next.getClass() : null;
                                throw new IllegalArgumentException("Expected String value for 'If-None-Match' header value, but received: " + clazz);
                            }
                            if (LAST_MODIFIED.equalsIgnoreCase(name)) {
                                if (value instanceof Date) {
                                    target.setLastModified(((Date)value).getTime());
                                    return;
                                }
                                if (value instanceof Number) {
                                    target.setLastModified(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    try {
                                        target.setLastModified(Long.parseLong((String)value));
                                        return;
                                    }
                                    catch (NumberFormatException e) {
                                        target.setLastModified(this.getFirstDate((String)value, LAST_MODIFIED));
                                        return;
                                    }
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Date, Number, or String value for 'Last-Modified' header value, but received: " + clazz);
                            }
                            if (LOCATION.equalsIgnoreCase(name)) {
                                if (value instanceof URI) {
                                    target.setLocation((URI)value);
                                    return;
                                }
                                if (value instanceof String) {
                                    try {
                                        target.setLocation(new URI((String)value));
                                        return;
                                    }
                                    catch (URISyntaxException e) {
                                        throw new IllegalArgumentException(e);
                                    }
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected URI or String value for 'Location' header value, but received: " + clazz);
                            }
                            if (PRAGMA.equalsIgnoreCase(name)) {
                                if (value instanceof String) {
                                    target.setPragma((String)value);
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected String value for 'Pragma' header value, but received: " + clazz);
                            }
                            if (value instanceof String) {
                                target.set(name, (String)value);
                                return;
                            }
                            if (value instanceof String[]) {
                                String[] clazz = (String[])value;
                                int ifNoneMatchList = clazz.length;
                                int longValue = 0;
                                while (longValue < ifNoneMatchList) {
                                    String next = clazz[longValue];
                                    target.add(name, next);
                                    ++longValue;
                                }
                                return;
                            }
                            if (!(value instanceof Iterable)) {
                                String convertedValue = this.convertToString(value);
                                if (StringUtils.hasText((String)convertedValue)) {
                                    target.set(name, convertedValue);
                                    return;
                                }
                                logger.warn((Object)("Header '" + name + "' with value '" + value + "' will not be set since it is not a String and no Converter is available. Consider registering a Converter with ConversionService (e.g., <int:converter>)"));
                                return;
                            }
                            break block100;
                        }
                        Collection values4 = (Collection)value;
                        if (CollectionUtils.isEmpty((Collection)values4)) return;
                        ArrayList<MediaType> acceptableMediaTypes2 = new ArrayList<MediaType>();
                        Iterator iterator = values4.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                target.setAccept(acceptableMediaTypes2);
                                return;
                            }
                            type2 = iterator.next();
                            if (type2 instanceof MediaType) {
                                acceptableMediaTypes2.add((MediaType)type2);
                                continue;
                            }
                            if (!(type2 instanceof String)) break;
                            acceptableMediaTypes2.addAll(MediaType.parseMediaTypes((String)((String)type2)));
                        }
                        Class<?> clazz = type2 != null ? type2.getClass() : null;
                        throw new IllegalArgumentException("Expected MediaType or String value for 'Accept' header value, but received: " + clazz);
                    }
                    Collection values5 = (Collection)value;
                    if (CollectionUtils.isEmpty((Collection)values5)) return;
                    ArrayList<Charset> acceptableCharsets = new ArrayList<Charset>();
                    Iterator iterator = values5.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            target.setAcceptCharset(acceptableCharsets);
                            return;
                        }
                        charset2 = iterator.next();
                        if (charset2 instanceof Charset) {
                            acceptableCharsets.add((Charset)charset2);
                            continue;
                        }
                        if (!(charset2 instanceof String)) break;
                        acceptableCharsets.add(Charset.forName((String)charset2));
                    }
                    Class<?> clazz = charset2 != null ? charset2.getClass() : null;
                    throw new IllegalArgumentException("Expected Charset or String value for 'Accept-Charset' header value, but received: " + clazz);
                }
                ArrayList<Charset> acceptableCharsets = new ArrayList<Charset>();
                Object[] objectArray = values = ObjectUtils.toObjectArray((Object)value);
                int charset2 = objectArray.length;
                int clazz = 0;
                while (true) {
                    if (clazz >= charset2) {
                        target.setAcceptCharset(acceptableCharsets);
                        return;
                    }
                    Object charset = objectArray[clazz];
                    if (charset instanceof Charset) {
                        acceptableCharsets.add((Charset)charset);
                    } else if (charset instanceof String) {
                        acceptableCharsets.add(Charset.forName((String)charset));
                    }
                    ++clazz;
                }
            }
            Collection values = (Collection)value;
            if (CollectionUtils.isEmpty((Collection)values)) return;
            HashSet<HttpMethod> allowedMethods = new HashSet<HttpMethod>();
            Iterator iterator = values.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    target.setAllow(allowedMethods);
                    return;
                }
                method2 = iterator.next();
                if (method2 instanceof HttpMethod) {
                    allowedMethods.add((HttpMethod)method2);
                    continue;
                }
                if (!(method2 instanceof String)) break;
                allowedMethods.add(HttpMethod.valueOf((String)((String)method2)));
            }
            Class<?> clazz = method2 != null ? method2.getClass() : null;
            throw new IllegalArgumentException("Expected HttpMethod or String value for 'Allow' header value, but received: " + clazz);
        }
        Iterator clazz = ((Iterable)value).iterator();
        while (clazz.hasNext()) {
            Object next = clazz.next();
            String convertedValue = null;
            convertedValue = next instanceof String ? (String)next : this.convertToString(value);
            if (StringUtils.hasText((String)convertedValue)) {
                target.add(name, convertedValue);
                continue;
            }
            logger.warn((Object)("Element of the header '" + name + "' with value '" + value + "' will not be set since it is not a String and no Converter is available. Consider registering a Converter with ConversionService (e.g., <int:converter>)"));
        }
    }

    private Object getHttpHeader(HttpHeaders source, String name) {
        if (ACCEPT.equalsIgnoreCase(name)) {
            return source.getAccept();
        }
        if (ACCEPT_CHARSET.equalsIgnoreCase(name)) {
            return source.getAcceptCharset();
        }
        if (ALLOW.equalsIgnoreCase(name)) {
            return source.getAllow();
        }
        if (CACHE_CONTROL.equalsIgnoreCase(name)) {
            String cacheControl = source.getCacheControl();
            return StringUtils.hasText((String)cacheControl) ? cacheControl : null;
        }
        if (CONTENT_LENGTH.equalsIgnoreCase(name)) {
            long contentLength = source.getContentLength();
            return contentLength > -1L ? Long.valueOf(contentLength) : null;
        }
        if (CONTENT_TYPE.equalsIgnoreCase(name)) {
            return source.getContentType();
        }
        if (DATE.equalsIgnoreCase(name)) {
            long date = source.getDate();
            return date > -1L ? Long.valueOf(date) : null;
        }
        if (ETAG.equalsIgnoreCase(name)) {
            String eTag = source.getETag();
            return StringUtils.hasText((String)eTag) ? eTag : null;
        }
        if (EXPIRES.equalsIgnoreCase(name)) {
            try {
                long expires = source.getExpires();
                return expires > -1L ? Long.valueOf(expires) : null;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage());
                }
                return null;
            }
        }
        if (IF_NONE_MATCH.equalsIgnoreCase(name)) {
            return source.getIfNoneMatch();
        }
        if (IF_MODIFIED_SINCE.equalsIgnoreCase(name)) {
            long modifiedSince = source.getIfModifiedSince();
            return modifiedSince > -1L ? Long.valueOf(modifiedSince) : null;
        }
        if (IF_UNMODIFIED_SINCE.equalsIgnoreCase(name)) {
            String unmodifiedSince = source.getFirst(IF_UNMODIFIED_SINCE);
            return unmodifiedSince != null ? Long.valueOf(this.getFirstDate(unmodifiedSince, IF_UNMODIFIED_SINCE)) : null;
        }
        if (LAST_MODIFIED.equalsIgnoreCase(name)) {
            long lastModified = source.getLastModified();
            return lastModified > -1L ? Long.valueOf(lastModified) : null;
        }
        if (LOCATION.equalsIgnoreCase(name)) {
            return source.getLocation();
        }
        if (PRAGMA.equalsIgnoreCase(name)) {
            String pragma = source.getPragma();
            return StringUtils.hasText((String)pragma) ? pragma : null;
        }
        return source.get((Object)name);
    }

    private void setMessageHeader(Map<String, Object> target, String name, Object value) {
        if (ObjectUtils.isArray((Object)value)) {
            Object[] values = ObjectUtils.toObjectArray((Object)value);
            if (!ObjectUtils.isEmpty((Object[])values)) {
                if (values.length == 1) {
                    target.put(name, values);
                } else {
                    target.put(name, values[0]);
                }
            }
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (!CollectionUtils.isEmpty((Collection)values)) {
                if (values.size() == 1) {
                    target.put(name, values.iterator().next());
                } else {
                    target.put(name, values);
                }
            }
        } else if (value != null) {
            target.put(name, value);
        }
    }

    private String convertToString(Object value) {
        if (this.conversionService != null && this.conversionService.canConvert(TypeDescriptor.forObject((Object)value), TypeDescriptor.valueOf(String.class))) {
            return (String)this.conversionService.convert(value, String.class);
        }
        return null;
    }

    private long getFirstDate(String headerValue, String headerName) {
        for (String dateFormat : DATE_FORMATS) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
            simpleDateFormat.setTimeZone(GMT);
            try {
                return simpleDateFormat.parse(headerValue).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse date value '" + headerValue + "' for '" + headerName + "' header");
    }

    private String formatDate(long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMATS[0], Locale.US);
        dateFormat.setTimeZone(GMT);
        return dateFormat.format(new Date(date));
    }

    public static DefaultHttpHeaderMapper outboundMapper() {
        DefaultHttpHeaderMapper mapper = new DefaultHttpHeaderMapper();
        mapper.setOutboundHeaderNames(HTTP_REQUEST_HEADER_NAMES);
        mapper.setInboundHeaderNames(HTTP_RESPONSE_HEADER_NAMES);
        mapper.setExcludedOutboundStandardRequestHeaderNames(HTTP_REQUEST_HEADER_NAMES_OUTBOUND_EXCLUSIONS);
        return mapper;
    }

    public static DefaultHttpHeaderMapper inboundMapper() {
        DefaultHttpHeaderMapper mapper = new DefaultHttpHeaderMapper();
        mapper.setInboundHeaderNames(HTTP_REQUEST_HEADER_NAMES);
        mapper.setOutboundHeaderNames(HTTP_RESPONSE_HEADER_NAMES);
        mapper.setExcludedInboundStandardResponseHeaderNames(HTTP_RESPONSE_HEADER_NAMES_INBOUND_EXCLUSIONS);
        return mapper;
    }

    static {
        for (String header : HTTP_REQUEST_HEADER_NAMES) {
            HTTP_REQUEST_HEADER_NAMES_LOWER.add(header.toLowerCase());
        }
        for (String header : HTTP_RESPONSE_HEADER_NAMES) {
            HTTP_RESPONSE_HEADER_NAMES_LOWER.add(header.toLowerCase());
        }
    }
}

