/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.inbound;

import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.collection.ItemEvent;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import java.util.HashMap;
import org.springframework.integration.hazelcast.HazelcastIntegrationDefinitionValidator;
import org.springframework.integration.hazelcast.inbound.AbstractHazelcastMessageProducer;
import org.springframework.util.Assert;

public class HazelcastEventDrivenMessageProducer
extends AbstractHazelcastMessageProducer {
    public HazelcastEventDrivenMessageProducer(DistributedObject distributedObject) {
        super(distributedObject);
    }

    protected void onInit() {
        super.onInit();
        HazelcastIntegrationDefinitionValidator.validateCacheTypeForEventDrivenMessageProducer(this.distributedObject);
    }

    protected void doStart() {
        if (this.distributedObject instanceof IMap) {
            this.setHazelcastRegisteredEventListenerId(((IMap)this.distributedObject).addEntryListener(new AbstractHazelcastMessageProducer.HazelcastEntryListener(), true));
        } else if (this.distributedObject instanceof MultiMap) {
            this.setHazelcastRegisteredEventListenerId(((MultiMap)this.distributedObject).addEntryListener(new AbstractHazelcastMessageProducer.HazelcastEntryListener(), true));
        } else if (this.distributedObject instanceof ReplicatedMap) {
            this.setHazelcastRegisteredEventListenerId(((ReplicatedMap)this.distributedObject).addEntryListener(new AbstractHazelcastMessageProducer.HazelcastEntryListener()));
        } else if (this.distributedObject instanceof IList) {
            this.setHazelcastRegisteredEventListenerId(((IList)this.distributedObject).addItemListener(new HazelcastItemListener(), true));
        } else if (this.distributedObject instanceof ISet) {
            this.setHazelcastRegisteredEventListenerId(((ISet)this.distributedObject).addItemListener(new HazelcastItemListener(), true));
        } else if (this.distributedObject instanceof IQueue) {
            this.setHazelcastRegisteredEventListenerId(((IQueue)this.distributedObject).addItemListener(new HazelcastItemListener(), true));
        } else if (this.distributedObject instanceof ITopic) {
            this.setHazelcastRegisteredEventListenerId(((ITopic)this.distributedObject).addMessageListener(new HazelcastMessageListener()));
        }
    }

    protected void doStop() {
        if (this.distributedObject instanceof IMap) {
            ((IMap)this.distributedObject).removeEntryListener(this.getHazelcastRegisteredEventListenerId());
        } else if (this.distributedObject instanceof MultiMap) {
            ((MultiMap)this.distributedObject).removeEntryListener(this.getHazelcastRegisteredEventListenerId());
        } else if (this.distributedObject instanceof ReplicatedMap) {
            ((ReplicatedMap)this.distributedObject).removeEntryListener(this.getHazelcastRegisteredEventListenerId());
        } else if (this.distributedObject instanceof IList) {
            ((IList)this.distributedObject).removeItemListener(this.getHazelcastRegisteredEventListenerId());
        } else if (this.distributedObject instanceof ISet) {
            ((ISet)this.distributedObject).removeItemListener(this.getHazelcastRegisteredEventListenerId());
        } else if (this.distributedObject instanceof IQueue) {
            ((IQueue)this.distributedObject).removeItemListener(this.getHazelcastRegisteredEventListenerId());
        } else if (this.distributedObject instanceof ITopic) {
            ((ITopic)this.distributedObject).removeMessageListener(this.getHazelcastRegisteredEventListenerId());
        }
    }

    public String getComponentType() {
        return "hazelcast:inbound-channel-adapter";
    }

    private class HazelcastItemListener<E>
    extends AbstractHazelcastMessageProducer.AbstractHazelcastEventListener<ItemEvent<E>>
    implements ItemListener<E> {
        private HazelcastItemListener() {
        }

        public void itemAdded(ItemEvent<E> item) {
            this.processEvent(item);
        }

        public void itemRemoved(ItemEvent<E> item) {
            this.processEvent(item);
        }

        @Override
        protected void processEvent(ItemEvent<E> event) {
            if (HazelcastEventDrivenMessageProducer.this.getCacheEvents().contains(event.getEventType().toString())) {
                this.sendMessage(event, event.getMember().getSocketAddress(EndpointQualifier.MEMBER), HazelcastEventDrivenMessageProducer.this.getCacheListeningPolicy());
            }
            if (HazelcastEventDrivenMessageProducer.this.logger.isDebugEnabled()) {
                HazelcastEventDrivenMessageProducer.this.logger.debug((CharSequence)("Received ItemEvent : " + event));
            }
        }

        @Override
        protected org.springframework.messaging.Message<?> toMessage(ItemEvent<E> event) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("hazelcast_eventType", event.getEventType().name());
            headers.put("hazelcast_member", event.getMember().getSocketAddress(EndpointQualifier.MEMBER));
            return HazelcastEventDrivenMessageProducer.this.getMessageBuilderFactory().withPayload(event.getItem()).copyHeaders(headers).build();
        }
    }

    private class HazelcastMessageListener<E>
    extends AbstractHazelcastMessageProducer.AbstractHazelcastEventListener<Message<E>>
    implements MessageListener<E> {
        private HazelcastMessageListener() {
        }

        public void onMessage(Message<E> message) {
            this.processEvent(message);
        }

        @Override
        protected void processEvent(Message<E> event) {
            this.sendMessage(event, event.getPublishingMember().getSocketAddress(EndpointQualifier.MEMBER), HazelcastEventDrivenMessageProducer.this.getCacheListeningPolicy());
            if (HazelcastEventDrivenMessageProducer.this.logger.isDebugEnabled()) {
                HazelcastEventDrivenMessageProducer.this.logger.debug((CharSequence)("Received Message : " + event));
            }
        }

        @Override
        protected org.springframework.messaging.Message<?> toMessage(Message<E> event) {
            Assert.notNull((Object)event.getMessageObject(), (String)"message must not be null");
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("hazelcast_member", event.getPublishingMember().getSocketAddress(EndpointQualifier.MEMBER));
            headers.put("hazelcast_cacheName", event.getSource());
            headers.put("hazelcast_publishingTime", event.getPublishTime());
            return HazelcastEventDrivenMessageProducer.this.getMessageBuilderFactory().withPayload(event.getMessageObject()).copyHeaders(headers).build();
        }
    }
}

