/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.SessionCallback;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class FtpRemoteFileTemplate
extends RemoteFileTemplate<FTPFile> {
    private ExistsMode existsMode = ExistsMode.STAT;

    public FtpRemoteFileTemplate(SessionFactory<FTPFile> sessionFactory) {
        super(sessionFactory);
    }

    public <T, C> T executeWithClient(ClientCallback<C, T> callback) {
        return this.doExecuteWithClient(callback);
    }

    public void setExistsMode(ExistsMode existsMode) {
        Assert.notNull((Object)((Object)existsMode), (String)"'existsMode' must not be null.");
        this.existsMode = existsMode;
    }

    protected <T> T doExecuteWithClient(final ClientCallback<FTPClient, T> callback) {
        return (T)this.execute(new SessionCallback<FTPFile, T>(){

            public T doInSession(Session<FTPFile> session) throws IOException {
                return callback.doWithClient((Object)((FTPClient)session.getClientInstance()));
            }
        });
    }

    public boolean exists(final String path) {
        return this.doExecuteWithClient(new ClientCallback<FTPClient, Boolean>(){

            public Boolean doWithClient(FTPClient client) {
                try {
                    switch (FtpRemoteFileTemplate.this.existsMode) {
                        case STAT: {
                            return client.getStatus(path) != null;
                        }
                        case NLST: {
                            Object[] names = client.listNames(path);
                            return !ObjectUtils.isEmpty((Object[])names);
                        }
                        case NLST_AND_DIRS: {
                            return FtpRemoteFileTemplate.this.getSession().exists(path);
                        }
                    }
                    throw new IllegalStateException("Unsupported 'existsMode': " + (Object)((Object)FtpRemoteFileTemplate.this.existsMode));
                }
                catch (IOException e) {
                    throw new MessagingException("Failed to check the remote path for " + path, (Throwable)e);
                }
            }
        });
    }

    public static enum ExistsMode {
        STAT,
        NLST,
        NLST_AND_DIRS;

    }
}

