/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.gateway;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.MessageSessionCallback;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.ftp.session.FtpFileInfo;
import org.springframework.integration.ftp.session.FtpRemoteFileTemplate;

public class FtpOutboundGateway
extends AbstractRemoteFileOutboundGateway<FTPFile> {
    public FtpOutboundGateway(SessionFactory<FTPFile> sessionFactory, MessageSessionCallback<FTPFile, ?> messageSessionCallback) {
        this((RemoteFileTemplate<FTPFile>)new FtpRemoteFileTemplate(sessionFactory), messageSessionCallback);
        ((FtpRemoteFileTemplate)this.remoteFileTemplate).setExistsMode(FtpRemoteFileTemplate.ExistsMode.NLST);
    }

    public FtpOutboundGateway(RemoteFileTemplate<FTPFile> remoteFileTemplate, MessageSessionCallback<FTPFile, ?> messageSessionCallback) {
        super(remoteFileTemplate, messageSessionCallback);
    }

    public FtpOutboundGateway(SessionFactory<FTPFile> sessionFactory, String command, String expression) {
        this(new FtpRemoteFileTemplate(sessionFactory), command, expression);
        ((FtpRemoteFileTemplate)this.remoteFileTemplate).setExistsMode(FtpRemoteFileTemplate.ExistsMode.NLST);
    }

    public FtpOutboundGateway(RemoteFileTemplate<FTPFile> remoteFileTemplate, String command, String expression) {
        super(remoteFileTemplate, command, expression);
    }

    public FtpOutboundGateway(SessionFactory<FTPFile> sessionFactory, String command) {
        this(sessionFactory, command, null);
    }

    public FtpOutboundGateway(RemoteFileTemplate<FTPFile> remoteFileTemplate, String command) {
        this(remoteFileTemplate, command, null);
    }

    public String getComponentType() {
        return "ftp:outbound-gateway";
    }

    protected boolean isDirectory(FTPFile file) {
        return file.isDirectory();
    }

    protected boolean isLink(FTPFile file) {
        return file.isSymbolicLink();
    }

    protected String getFilename(FTPFile file) {
        return file.getName();
    }

    protected String getFilename(AbstractFileInfo<FTPFile> file) {
        return file.getFilename();
    }

    protected long getModified(FTPFile file) {
        return file.getTimestamp().getTimeInMillis();
    }

    protected List<AbstractFileInfo<FTPFile>> asFileInfoList(Collection<FTPFile> files) {
        ArrayList<AbstractFileInfo<FTPFile>> canonicalFiles = new ArrayList<AbstractFileInfo<FTPFile>>();
        for (FTPFile file : files) {
            canonicalFiles.add(new FtpFileInfo(file));
        }
        return canonicalFiles;
    }

    protected FTPFile enhanceNameWithSubDirectory(FTPFile file, String directory) {
        file.setName(directory + file.getName());
        return file;
    }
}

