/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.dsl;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.outbound.FileWritingMessageHandler;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.messaging.Message;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class FileWritingMessageHandlerSpec
extends MessageHandlerSpec<FileWritingMessageHandlerSpec, FileWritingMessageHandler>
implements ComponentsRegistration {
    private @Nullable FileNameGenerator fileNameGenerator;
    private @Nullable DefaultFileNameGenerator defaultFileNameGenerator;

    protected FileWritingMessageHandlerSpec(File destinationDirectory) {
        this.target = new FileWritingMessageHandler(destinationDirectory);
    }

    protected FileWritingMessageHandlerSpec(String directoryExpression) {
        this(PARSER.parseExpression(directoryExpression));
    }

    protected <P> FileWritingMessageHandlerSpec(Function<Message<P>, ?> directoryFunction) {
        this((Expression)new FunctionExpression(directoryFunction));
    }

    protected FileWritingMessageHandlerSpec(Expression directoryExpression) {
        this.target = new FileWritingMessageHandler(directoryExpression);
    }

    FileWritingMessageHandlerSpec expectReply(boolean expectReply) {
        ((FileWritingMessageHandler)((Object)this.target)).setExpectReply(expectReply);
        if (expectReply) {
            ((FileWritingMessageHandler)((Object)this.target)).setRequiresReply(true);
        }
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileWritingMessageHandler)((Object)this.target)).setAutoCreateDirectory(autoCreateDirectory);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec temporaryFileSuffix(String temporaryFileSuffix) {
        ((FileWritingMessageHandler)((Object)this.target)).setTemporaryFileSuffix(temporaryFileSuffix);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec fileExistsMode(FileExistsMode fileExistsMode) {
        ((FileWritingMessageHandler)((Object)this.target)).setFileExistsMode(fileExistsMode);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec fileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
        ((FileWritingMessageHandler)((Object)this.target)).setFileNameGenerator(fileNameGenerator);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec fileNameExpression(String fileNameExpression) {
        Assert.isNull((Object)this.fileNameGenerator, (String)"'fileNameGenerator' and 'fileNameGeneratorExpression' are mutually exclusive.");
        this.defaultFileNameGenerator = new DefaultFileNameGenerator();
        this.defaultFileNameGenerator.setExpression(fileNameExpression);
        return this.fileNameGenerator(this.defaultFileNameGenerator);
    }

    public FileWritingMessageHandlerSpec deleteSourceFiles(boolean deleteSourceFiles) {
        ((FileWritingMessageHandler)((Object)this.target)).setDeleteSourceFiles(deleteSourceFiles);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec charset(String charset) {
        ((FileWritingMessageHandler)((Object)this.target)).setCharset(charset);
        return (FileWritingMessageHandlerSpec)this._this();
    }

    public FileWritingMessageHandlerSpec appendNewLine(boolean appendNewLine) {
        ((FileWritingMessageHandler)((Object)this.target)).setAppendNewLine(appendNewLine);
        return this;
    }

    public FileWritingMessageHandlerSpec bufferSize(int bufferSize) {
        ((FileWritingMessageHandler)((Object)this.target)).setBufferSize(bufferSize);
        return this;
    }

    public FileWritingMessageHandlerSpec flushInterval(long flushInterval) {
        ((FileWritingMessageHandler)((Object)this.target)).setFlushInterval(flushInterval);
        return this;
    }

    public FileWritingMessageHandlerSpec flushWhenIdle(boolean flushWhenIdle) {
        ((FileWritingMessageHandler)((Object)this.target)).setFlushWhenIdle(flushWhenIdle);
        return this;
    }

    public FileWritingMessageHandlerSpec taskScheduler(TaskScheduler taskScheduler) {
        ((FileWritingMessageHandler)((Object)this.target)).setTaskScheduler(taskScheduler);
        return this;
    }

    public FileWritingMessageHandlerSpec flushPredicate(FileWritingMessageHandler.MessageFlushPredicate flushPredicate) {
        ((FileWritingMessageHandler)((Object)this.target)).setFlushPredicate(flushPredicate);
        return this;
    }

    public FileWritingMessageHandlerSpec preserveTimestamp(boolean preserveTimestamp) {
        ((FileWritingMessageHandler)((Object)this.target)).setPreserveTimestamp(preserveTimestamp);
        return this;
    }

    public FileWritingMessageHandlerSpec chmod(int chmod) {
        ((FileWritingMessageHandler)((Object)this.target)).setChmod(chmod);
        return this;
    }

    public Map<Object, @Nullable String> getComponentsToRegister() {
        if (this.defaultFileNameGenerator != null) {
            return Collections.singletonMap(this.defaultFileNameGenerator, null);
        }
        return Collections.emptyMap();
    }
}

