/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.file.filters.AcceptAllFileListFilter;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.IgnoreHiddenFileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;

public class FileListFilterFactoryBean
implements FactoryBean<FileListFilter<File>> {
    private volatile @Nullable FileListFilter<File> result;
    private volatile @Nullable FileListFilter<File> filter;
    private volatile @Nullable String filenamePattern;
    private volatile @Nullable String filenameRegex;
    private volatile Boolean ignoreHidden = Boolean.TRUE;
    private volatile @Nullable Boolean preventDuplicates;
    private volatile @Nullable Boolean alwaysAcceptDirectories;
    private final Lock monitor = new ReentrantLock();

    public void setFilter(FileListFilter<File> filter) {
        this.filter = filter;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    public void setFilenameRegex(String filenameRegex) {
        this.filenameRegex = filenameRegex;
    }

    public void setIgnoreHidden(Boolean ignoreHidden) {
        this.ignoreHidden = ignoreHidden;
    }

    public void setPreventDuplicates(Boolean preventDuplicates) {
        this.preventDuplicates = preventDuplicates;
    }

    public void setAlwaysAcceptDirectories(Boolean alwaysAcceptDirectories) {
        this.alwaysAcceptDirectories = alwaysAcceptDirectories;
    }

    public FileListFilter<File> getObject() {
        FileListFilter<File> filterToReturn = this.result;
        if (filterToReturn == null) {
            this.monitor.lock();
            try {
                filterToReturn = this.result;
                if (filterToReturn == null) {
                    this.result = filterToReturn = this.initializeFileListFilter();
                }
            }
            finally {
                this.monitor.unlock();
            }
        }
        return filterToReturn;
    }

    public Class<?> getObjectType() {
        FileListFilter<File> filterToCheck = this.result;
        return filterToCheck != null ? filterToCheck.getClass() : FileListFilter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private FileListFilter<File> initializeFileListFilter() {
        FileListFilter<File> filterToAdd;
        this.validate();
        ArrayList<FileListFilter<File>> filtersNeeded = new ArrayList<FileListFilter<File>>();
        if (!Boolean.FALSE.equals(this.ignoreHidden)) {
            filtersNeeded.add(new IgnoreHiddenFileListFilter());
        }
        if ((filterToAdd = this.filter) != null) {
            this.filter(filtersNeeded, filterToAdd);
        } else if (this.filenamePattern != null || this.filenameRegex != null) {
            this.pattern(filtersNeeded);
        } else if (Boolean.FALSE.equals(this.preventDuplicates)) {
            filtersNeeded.add(new AcceptAllFileListFilter());
        } else {
            filtersNeeded.add(new AcceptOnceFileListFilter());
        }
        if (filtersNeeded.size() == 1) {
            return (FileListFilter)filtersNeeded.get(0);
        }
        return new CompositeFileListFilter<File>(filtersNeeded);
    }

    private void validate() {
        if (this.filter != null && (this.filenamePattern != null || this.filenameRegex != null)) {
            throw new IllegalArgumentException("The 'filter' reference is mutually exclusive with either the 'filename-pattern' or 'filename-regex' attribute.");
        }
        if (this.filenamePattern != null && this.filenameRegex != null) {
            throw new IllegalArgumentException("The 'filename-pattern' and 'filename-regex' attributes are mutually exclusive.");
        }
    }

    private void filter(List<FileListFilter<File>> filtersNeeded, FileListFilter<File> filter) {
        if (Boolean.TRUE.equals(this.preventDuplicates)) {
            filtersNeeded.add(new AcceptOnceFileListFilter());
            filtersNeeded.add(filter);
        } else {
            filtersNeeded.add(filter);
        }
    }

    private void pattern(List<FileListFilter<File>> filtersNeeded) {
        String filenameRegexToUse;
        if (!Boolean.FALSE.equals(this.preventDuplicates)) {
            filtersNeeded.add(new AcceptOnceFileListFilter());
        }
        String filenamePatternToUse = this.filenamePattern;
        Boolean alwaysAcceptDirectoriesToUse = this.alwaysAcceptDirectories;
        if (filenamePatternToUse != null) {
            SimplePatternFileListFilter patternFilter = new SimplePatternFileListFilter(filenamePatternToUse);
            if (alwaysAcceptDirectoriesToUse != null) {
                patternFilter.setAlwaysAcceptDirectories(alwaysAcceptDirectoriesToUse);
            }
            filtersNeeded.add(patternFilter);
        }
        if ((filenameRegexToUse = this.filenameRegex) != null) {
            RegexPatternFileListFilter regexFilter = new RegexPatternFileListFilter(filenameRegexToUse);
            if (alwaysAcceptDirectoriesToUse != null) {
                regexFilter.setAlwaysAcceptDirectories(alwaysAcceptDirectoriesToUse);
            }
            filtersNeeded.add(regexFilter);
        }
    }
}

