/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.dsl;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.handler.FileTransferringMessageHandler;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class FileTransferringMessageHandlerSpec<F, S extends FileTransferringMessageHandlerSpec<F, S>>
extends MessageHandlerSpec<S, FileTransferringMessageHandler<F>>
implements ComponentsRegistration {
    private FileNameGenerator fileNameGenerator;
    private DefaultFileNameGenerator defaultFileNameGenerator;

    protected FileTransferringMessageHandlerSpec(SessionFactory<F> sessionFactory) {
        this.target = new FileTransferringMessageHandler<F>(sessionFactory);
    }

    protected FileTransferringMessageHandlerSpec(RemoteFileTemplate<F> remoteFileTemplate) {
        this.target = new FileTransferringMessageHandler<F>(remoteFileTemplate);
    }

    protected FileTransferringMessageHandlerSpec(RemoteFileTemplate<F> remoteFileTemplate, FileExistsMode fileExistsMode) {
        this.target = new FileTransferringMessageHandler<F>(remoteFileTemplate, fileExistsMode);
    }

    public S autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileTransferringMessageHandler)((Object)this.target)).setAutoCreateDirectory(autoCreateDirectory);
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        ((FileTransferringMessageHandler)((Object)this.target)).setRemoteFileSeparator(remoteFileSeparator);
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S remoteDirectory(String remoteDirectory) {
        ((FileTransferringMessageHandler)((Object)this.target)).setRemoteDirectoryExpression((Expression)new LiteralExpression(remoteDirectory));
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S remoteDirectoryExpression(String remoteDirectoryExpression) {
        ((FileTransferringMessageHandler)((Object)this.target)).setRemoteDirectoryExpression(PARSER.parseExpression(remoteDirectoryExpression));
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public <P> S remoteDirectory(Function<Message<P>, String> remoteDirectoryFunction) {
        ((FileTransferringMessageHandler)((Object)this.target)).setRemoteDirectoryExpression((Expression)new FunctionExpression(remoteDirectoryFunction));
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S temporaryRemoteDirectory(String temporaryRemoteDirectory) {
        ((FileTransferringMessageHandler)((Object)this.target)).setTemporaryRemoteDirectoryExpression((Expression)new LiteralExpression(temporaryRemoteDirectory));
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S temporaryRemoteDirectoryExpression(String temporaryRemoteDirectoryExpression) {
        ((FileTransferringMessageHandler)((Object)this.target)).setTemporaryRemoteDirectoryExpression(PARSER.parseExpression(temporaryRemoteDirectoryExpression));
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public <P> S temporaryRemoteDirectory(Function<Message<P>, String> temporaryRemoteDirectoryFunction) {
        ((FileTransferringMessageHandler)((Object)this.target)).setTemporaryRemoteDirectoryExpression((Expression)new FunctionExpression(temporaryRemoteDirectoryFunction));
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S useTemporaryFileName(boolean useTemporaryFileName) {
        ((FileTransferringMessageHandler)((Object)this.target)).setUseTemporaryFileName(useTemporaryFileName);
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S fileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
        ((FileTransferringMessageHandler)((Object)this.target)).setFileNameGenerator(fileNameGenerator);
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S fileNameExpression(String fileNameGeneratorExpression) {
        Assert.isNull((Object)this.fileNameGenerator, (String)"'fileNameGenerator' and 'fileNameGeneratorExpression' are mutually exclusive.");
        this.defaultFileNameGenerator = new DefaultFileNameGenerator();
        this.defaultFileNameGenerator.setExpression(fileNameGeneratorExpression);
        return this.fileNameGenerator(this.defaultFileNameGenerator);
    }

    public S charset(String charset) {
        ((FileTransferringMessageHandler)((Object)this.target)).setCharset(charset);
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S charset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' must not be null.");
        return this.charset(charset.name());
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        ((FileTransferringMessageHandler)((Object)this.target)).setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public S chmod(int chmod) {
        ((FileTransferringMessageHandler)((Object)this.target)).setChmod(chmod);
        return (S)((Object)((FileTransferringMessageHandlerSpec)this._this()));
    }

    public Map<Object, String> getComponentsToRegister() {
        if (this.defaultFileNameGenerator != null) {
            return Collections.singletonMap(this.defaultFileNameGenerator, null);
        }
        return null;
    }
}

