/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.springframework.expression.Expression;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferringMessageHandler
extends AbstractMessageHandler {
    private final SessionFactory sessionFactory;
    private volatile ExpressionEvaluatingMessageProcessor<String> directoryExpressionProcessor;
    private volatile FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private volatile File temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
    private volatile String charset = "UTF-8";

    public FileTransferringMessageHandler(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"sessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.directoryExpressionProcessor = new ExpressionEvaluatingMessageProcessor(remoteDirectoryExpression);
    }

    public void setTemporaryDirectory(File temporaryDirectory) {
        Assert.notNull((Object)temporaryDirectory, (String)"temporaryDirectory must not be null");
        this.temporaryDirectory = temporaryDirectory;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator != null ? fileNameGenerator : new DefaultFileNameGenerator();
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected void onInit() throws Exception {
        Assert.notNull(this.directoryExpressionProcessor, (String)"remoteDirectoryExpression is required");
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        File file = this.redeemForStorableFile(message);
        if (file != null && file.exists()) {
            Session session = this.sessionFactory.getSession();
            try {
                String targetDirectory = (String)this.directoryExpressionProcessor.processMessage(message);
                String fileName = this.fileNameGenerator.generateFileName(message);
                this.sendFileToRemoteDirectory(file, targetDirectory, fileName, session);
            }
            catch (FileNotFoundException e) {
                throw new MessageDeliveryException(message, "File [" + file + "] not found in local working directory; it was moved or deleted unexpectedly.", (Throwable)e);
            }
            catch (IOException e) {
                throw new MessageDeliveryException(message, "Failed to transfer file [" + file + "] from local working directory to remote FTP directory.", (Throwable)e);
            }
            catch (Exception e) {
                throw new MessageDeliveryException(message, "Error handling message for file [" + file + "]", (Throwable)e);
            }
            finally {
                if (!(message.getPayload() instanceof File) && file.exists()) {
                    try {
                        file.delete();
                    }
                    catch (Throwable th) {}
                }
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    private File redeemForStorableFile(Message<?> message) throws MessageDeliveryException {
        try {
            Object payload = message.getPayload();
            File sendableFile = null;
            if (payload instanceof File) {
                sendableFile = (File)payload;
            } else if (payload instanceof byte[] || payload instanceof String) {
                String tempFileName = this.fileNameGenerator.generateFileName(message) + ".tmp";
                sendableFile = new File(this.temporaryDirectory, tempFileName);
                byte[] bytes = null;
                bytes = payload instanceof String ? ((String)payload).getBytes(this.charset) : (byte[])payload;
                FileCopyUtils.copy((byte[])bytes, (File)sendableFile);
            } else {
                throw new IllegalArgumentException("Unsupported payload type. The only supported payloads are java.io.File, java.lang.String and byte[]");
            }
            return sendableFile;
        }
        catch (Exception e) {
            throw new MessageDeliveryException(message, "Failed to create sendable file.", (Throwable)e);
        }
    }

    private void sendFileToRemoteDirectory(File file, String remoteDirectory, String pathTo, Session session) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        if (!StringUtils.endsWithIgnoreCase((String)remoteDirectory, (String)File.separator)) {
            remoteDirectory = remoteDirectory + File.separatorChar;
        }
        String remoteFilePath = remoteDirectory + file.getName() + ".writing";
        session.write(fileInputStream, remoteFilePath);
        fileInputStream.close();
        session.rename(remoteFilePath, pathTo);
    }
}

