/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.HeadDirectoryScanner;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReadingMessageSource
extends IntegrationObjectSupport
implements MessageSource<File> {
    private static final int DEFAULT_INTERNAL_QUEUE_CAPACITY = 5;
    private static final Log logger = LogFactory.getLog(FileReadingMessageSource.class);
    private volatile File directory;
    private volatile DirectoryScanner scanner = new DefaultDirectoryScanner();
    private volatile boolean autoCreateDirectory = true;
    private final Queue<File> toBeReceived;
    private volatile boolean scanEachPoll = false;

    public FileReadingMessageSource() {
        this(null);
    }

    public FileReadingMessageSource(int internalQueueCapacity) {
        this(null);
        Assert.isTrue((internalQueueCapacity > 0 ? 1 : 0) != 0, (String)"Cannot create a queue with non positive capacity");
        this.setScanner(new HeadDirectoryScanner(internalQueueCapacity));
    }

    public FileReadingMessageSource(Comparator<File> receptionOrderComparator) {
        this.toBeReceived = new PriorityBlockingQueue<File>(5, receptionOrderComparator);
    }

    public void setDirectory(File directory) {
        Assert.notNull((Object)directory, (String)"directory must not be null");
        this.directory = directory;
    }

    public void setScanner(DirectoryScanner scanner) {
        this.scanner = scanner;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setFilter(FileListFilter<File> filter) {
        Assert.notNull(filter, (String)"'filter' must not be null");
        this.scanner.setFilter(filter);
    }

    public void setLocker(FileLocker locker) {
        Assert.notNull((Object)locker, (String)"'fileLocker' must not be null.");
        this.scanner.setLocker(locker);
    }

    public void setScanEachPoll(boolean scanEachPoll) {
        this.scanEachPoll = scanEachPoll;
    }

    public String getComponentType() {
        return "file:inbound-channel-adapter";
    }

    protected void onInit() {
        Assert.notNull((Object)this.directory, (String)"'directory' must not be null");
        if (!this.directory.exists() && this.autoCreateDirectory) {
            this.directory.mkdirs();
        }
        Assert.isTrue((boolean)this.directory.exists(), (String)("Source directory [" + this.directory + "] does not exist."));
        Assert.isTrue((boolean)this.directory.isDirectory(), (String)("Source path [" + this.directory + "] does not point to a directory."));
        Assert.isTrue((boolean)this.directory.canRead(), (String)("Source directory [" + this.directory + "] is not readable."));
    }

    public Message<File> receive() throws MessagingException {
        Message message = null;
        if (this.scanEachPoll || this.toBeReceived.isEmpty()) {
            this.scanInputDirectory();
        }
        File file = this.toBeReceived.poll();
        while (file != null && !this.scanner.tryClaim(file)) {
            file = this.toBeReceived.poll();
        }
        if (file != null) {
            message = MessageBuilder.withPayload((Object)file).build();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Created message: [" + message + "]"));
            }
        }
        return message;
    }

    private void scanInputDirectory() {
        List<File> filteredFiles = this.scanner.listFiles(this.directory);
        HashSet<File> freshFiles = new HashSet<File>(filteredFiles);
        if (!freshFiles.isEmpty()) {
            this.toBeReceived.addAll(freshFiles);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added to queue: " + freshFiles));
            }
        }
    }

    public void onFailure(Message<File> failedMessage) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Failed to send: " + failedMessage));
        }
        this.toBeReceived.offer((File)failedMessage.getPayload());
    }

    public void onSend(Message<File> sentMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sent: " + sentMessage));
        }
    }
}

