/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.aws.support.SnsBodyBuilder;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class SnsMessageHandler
extends AbstractReplyProducingMessageHandler {
    private final AmazonSNS amazonSns;
    private final boolean produceReply;
    private EvaluationContext evaluationContext;
    private Expression topicArnExpression;
    private Expression subjectExpression;
    private Expression bodyExpression;
    private ResourceIdResolver resourceIdResolver;

    public SnsMessageHandler(AmazonSNS amazonSns) {
        this(amazonSns, false);
    }

    public SnsMessageHandler(AmazonSNS amazonSns, boolean produceReply) {
        Assert.notNull((Object)amazonSns, (String)"amazonSns must not be null.");
        this.amazonSns = amazonSns;
        this.produceReply = produceReply;
    }

    public void setTopicArn(String topicArn) {
        Assert.hasText((String)topicArn, (String)"topicArn must not be empty.");
        this.topicArnExpression = new LiteralExpression(topicArn);
    }

    public void setTopicArnExpression(Expression topicArnExpression) {
        Assert.notNull((Object)topicArnExpression, (String)"topicArnExpression must not be null.");
        this.topicArnExpression = topicArnExpression;
    }

    public void setSubject(String subject) {
        Assert.hasText((String)subject, (String)"subject must not be empty.");
        this.subjectExpression = new LiteralExpression(subject);
    }

    public void setSubjectExpression(Expression subjectExpression) {
        Assert.notNull((Object)subjectExpression, (String)"subjectExpression must not be null.");
        this.subjectExpression = subjectExpression;
    }

    public void setBodyExpression(Expression bodyExpression) {
        Assert.notNull((Object)bodyExpression, (String)"bodyExpression must not be null.");
        this.bodyExpression = bodyExpression;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    protected void doInit() {
        super.doInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        TypeLocator typeLocator = this.evaluationContext.getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            ((StandardTypeLocator)typeLocator).registerImport("org.springframework.integration.aws.support");
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object payload = requestMessage.getPayload();
        PublishRequest publishRequest = null;
        if (payload instanceof PublishRequest) {
            publishRequest = (PublishRequest)payload;
        } else {
            Assert.state((this.topicArnExpression != null ? 1 : 0) != 0, (String)"'topicArn' or 'topicArnExpression' must be specified.");
            publishRequest = new PublishRequest();
            String topicArn = (String)this.topicArnExpression.getValue(this.evaluationContext, requestMessage, String.class);
            if (this.resourceIdResolver != null) {
                topicArn = this.resourceIdResolver.resolveToPhysicalResourceId(topicArn);
            }
            publishRequest.setTopicArn(topicArn);
            if (this.subjectExpression != null) {
                String subject = (String)this.subjectExpression.getValue(this.evaluationContext, requestMessage, String.class);
                publishRequest.setSubject(subject);
            }
            Object snsMessage = requestMessage.getPayload();
            if (this.bodyExpression != null) {
                snsMessage = this.bodyExpression.getValue(this.evaluationContext, requestMessage);
            }
            if (snsMessage instanceof SnsBodyBuilder) {
                publishRequest.withMessageStructure("json").setMessage(((SnsBodyBuilder)snsMessage).build());
            } else {
                publishRequest.setMessage((String)this.getConversionService().convert(snsMessage, String.class));
            }
        }
        PublishResult publishResult = this.amazonSns.publish(publishRequest);
        if (this.produceReply) {
            return this.getMessageBuilderFactory().withPayload((Object)publishRequest).setHeader("aws_topic", (Object)publishRequest.getTopicArn()).setHeader("aws_snsPublishedMessageId", (Object)publishResult.getMessageId());
        }
        return null;
    }
}

