/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.inbound;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.support.S3SessionFactory;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;

public class S3InboundFileSynchronizer
extends AbstractInboundFileSynchronizer<S3ObjectSummary> {
    public S3InboundFileSynchronizer() {
        this(new S3SessionFactory());
    }

    public S3InboundFileSynchronizer(AmazonS3 amazonS3) {
        this(new S3SessionFactory(amazonS3));
    }

    public S3InboundFileSynchronizer(SessionFactory<S3ObjectSummary> sessionFactory) {
        super(sessionFactory);
        this.setRemoteDirectoryExpression((Expression)new LiteralExpression(null));
    }

    protected boolean isFile(S3ObjectSummary file) {
        return true;
    }

    protected String getFilename(S3ObjectSummary file) {
        return file != null ? file.getKey() : null;
    }

    protected long getModified(S3ObjectSummary file) {
        return file.getLastModified().getTime();
    }
}

