/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.aws.outbound.SnsMessageHandler;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.w3c.dom.Element;

public class SnsOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinition message;
        BeanDefinition subject;
        String sns = element.getAttribute("sns");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SnsMessageHandler.class).addConstructorArgReference(sns).addConstructorArgValue((Object)true);
        BeanDefinition topic = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"topic-arn", (String)"topic-arn-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        if (topic != null) {
            builder.addPropertyValue("topicArnExpression", (Object)topic);
        }
        if ((subject = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"subject", (String)"subject-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            builder.addPropertyValue("subjectExpression", (Object)subject);
        }
        if ((message = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"body-expression", (Element)element)) != null) {
            builder.addPropertyValue("bodyExpression", (Object)message);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"resource-id-resolver");
        return builder;
    }
}

