/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.dsl;

import org.springframework.integration.amqp.outbound.RabbitStreamMessageHandler;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.messaging.MessageChannel;
import org.springframework.rabbit.stream.producer.RabbitStreamOperations;

public class RabbitStreamMessageHandlerSpec
extends MessageHandlerSpec<RabbitStreamMessageHandlerSpec, RabbitStreamMessageHandler> {
    private final DefaultAmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.outboundMapper();

    RabbitStreamMessageHandlerSpec(RabbitStreamOperations operations) {
        this.target = new RabbitStreamMessageHandler(operations);
    }

    public RabbitStreamMessageHandlerSpec headerMapper(AmqpHeaderMapper headerMapper) {
        ((RabbitStreamMessageHandler)((Object)this.target)).setHeaderMapper(headerMapper);
        return this;
    }

    public RabbitStreamMessageHandlerSpec mappedRequestHeaders(String ... headers) {
        this.headerMapper.setRequestHeaderNames(headers);
        return this;
    }

    public RabbitStreamMessageHandlerSpec headersMappedLast(boolean headersLast) {
        ((RabbitStreamMessageHandler)((Object)this.target)).setHeadersMappedLast(headersLast);
        return this;
    }

    public RabbitStreamMessageHandlerSpec sendSuccessChannel(MessageChannel channel) {
        ((RabbitStreamMessageHandler)((Object)this.target)).setSendSuccessChannel(channel);
        return this;
    }

    public RabbitStreamMessageHandlerSpec sendFailureChannel(MessageChannel channel) {
        ((RabbitStreamMessageHandler)((Object)this.target)).setSendFailureChannel(channel);
        return this;
    }

    public RabbitStreamMessageHandlerSpec sendSuccessChannel(String channel) {
        ((RabbitStreamMessageHandler)((Object)this.target)).setSendSuccessChannelName(channel);
        return this;
    }

    public RabbitStreamMessageHandlerSpec sendFailureChannel(String channel) {
        ((RabbitStreamMessageHandler)((Object)this.target)).setSendFailureChannelName(channel);
        return this;
    }

    public RabbitStreamMessageHandlerSpec sync(boolean sync) {
        ((RabbitStreamMessageHandler)((Object)this.target)).setSync(sync);
        return this;
    }

    public RabbitStreamMessageHandlerSpec confirmTimeout(long timeout) {
        ((RabbitStreamMessageHandler)((Object)this.target)).setConfirmTimeout(timeout);
        return this;
    }
}

