/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.mapping.AbstractHeaderMapper;
import org.springframework.integration.mapping.support.JsonHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class DefaultAmqpHeaderMapper
extends AbstractHeaderMapper<MessageProperties>
implements AmqpHeaderMapper {
    private static final List<String> STANDARD_HEADER_NAMES = new ArrayList<String>();

    protected DefaultAmqpHeaderMapper(String[] requestHeaderNames, String[] replyHeaderNames) {
        super("amqp_", STANDARD_HEADER_NAMES, STANDARD_HEADER_NAMES);
        if (requestHeaderNames != null) {
            this.setRequestHeaderNames(requestHeaderNames);
        }
        if (replyHeaderNames != null) {
            this.setReplyHeaderNames(replyHeaderNames);
        }
    }

    protected Map<String, Object> extractStandardHeaders(MessageProperties amqpMessageProperties) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        try {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)"amqp_appId", (Object)amqpMessageProperties.getAppId(), headers::put).acceptIfNotNull((Object)"amqp_clusterId", (Object)amqpMessageProperties.getClusterId(), headers::put).acceptIfNotNull((Object)"amqp_contentEncoding", (Object)amqpMessageProperties.getContentEncoding(), headers::put);
            long contentLength = amqpMessageProperties.getContentLength();
            JavaUtils.INSTANCE.acceptIfCondition(contentLength > 0L, (Object)"amqp_contentLength", (Object)contentLength, headers::put).acceptIfHasText((Object)"contentType", amqpMessageProperties.getContentType(), headers::put).acceptIfHasText((Object)"amqp_correlationId", amqpMessageProperties.getCorrelationId(), headers::put).acceptIfNotNull((Object)"amqp_receivedDeliveryMode", (Object)amqpMessageProperties.getReceivedDeliveryMode(), headers::put);
            long deliveryTag = amqpMessageProperties.getDeliveryTag();
            JavaUtils.INSTANCE.acceptIfCondition(deliveryTag > 0L, (Object)"amqp_deliveryTag", (Object)deliveryTag, headers::put).acceptIfHasText((Object)"amqp_expiration", amqpMessageProperties.getExpiration(), headers::put);
            Integer messageCount = amqpMessageProperties.getMessageCount();
            JavaUtils.INSTANCE.acceptIfCondition(messageCount != null && messageCount > 0, (Object)"amqp_messageCount", (Object)messageCount, headers::put).acceptIfHasText((Object)"amqp_messageId", amqpMessageProperties.getMessageId(), headers::put);
            Integer priority = amqpMessageProperties.getPriority();
            JavaUtils.INSTANCE.acceptIfCondition(priority != null && priority > 0, (Object)"priority", (Object)priority, headers::put).acceptIfNotNull((Object)"amqp_receivedDelay", (Object)amqpMessageProperties.getReceivedDelay(), headers::put).acceptIfNotNull((Object)"amqp_receivedExchange", (Object)amqpMessageProperties.getReceivedExchange(), headers::put).acceptIfHasText((Object)"amqp_receivedRoutingKey", amqpMessageProperties.getReceivedRoutingKey(), headers::put).acceptIfNotNull((Object)"amqp_redelivered", (Object)amqpMessageProperties.isRedelivered(), headers::put).acceptIfNotNull((Object)"amqp_replyTo", (Object)amqpMessageProperties.getReplyTo(), headers::put).acceptIfNotNull((Object)"amqp_timestamp", (Object)amqpMessageProperties.getTimestamp(), headers::put).acceptIfHasText((Object)"amqp_type", amqpMessageProperties.getType(), headers::put).acceptIfHasText((Object)"amqp_receivedUserId", amqpMessageProperties.getReceivedUserId(), headers::put);
            for (String jsonHeader : JsonHeaders.HEADERS) {
                Object value = amqpMessageProperties.getHeaders().get(jsonHeader.replaceFirst("json", ""));
                if (!(value instanceof String) || !StringUtils.hasText((String)((String)value))) continue;
                headers.put(jsonHeader, value);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"error occurred while mapping from AMQP properties to MessageHeaders", (Throwable)e);
        }
        return headers;
    }

    protected Map<String, Object> extractUserDefinedHeaders(MessageProperties amqpMessageProperties) {
        return amqpMessageProperties.getHeaders();
    }

    protected void populateStandardHeaders(Map<String, Object> headers, MessageProperties amqpMessageProperties) {
        this.populateStandardHeaders(null, headers, amqpMessageProperties);
    }

    protected void populateStandardHeaders(@Nullable Map<String, Object> allHeaders, Map<String, Object> headers, MessageProperties amqpMessageProperties) {
        Long ts;
        UUID id;
        JavaUtils.INSTANCE.acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_appId", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setAppId(arg_0)).acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_clusterId", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setClusterId(arg_0)).acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_contentEncoding", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setContentEncoding(arg_0)).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_contentLength", Long.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setContentLength(arg_0)).acceptIfHasText(this.extractContentTypeAsString(headers), arg_0 -> ((MessageProperties)amqpMessageProperties).setContentType(arg_0)).acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_correlationId", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setCorrelationId(arg_0)).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_delay", Integer.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setDelay(arg_0)).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_deliveryMode", MessageDeliveryMode.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setDeliveryMode(arg_0)).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_deliveryTag", Long.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setDeliveryTag(arg_0)).acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_expiration", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setExpiration(arg_0)).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_messageCount", Integer.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setMessageCount(arg_0));
        String messageId = (String)this.getHeaderIfAvailable(headers, "amqp_messageId", String.class);
        if (StringUtils.hasText((String)messageId)) {
            amqpMessageProperties.setMessageId(messageId);
        } else if (allHeaders != null && (id = (UUID)this.getHeaderIfAvailable(allHeaders, "id", UUID.class)) != null) {
            amqpMessageProperties.setMessageId(id.toString());
        }
        JavaUtils.INSTANCE.acceptIfNotNull(this.getHeaderIfAvailable(headers, "priority", Integer.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setPriority(arg_0)).acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_receivedExchange", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setReceivedExchange(arg_0)).acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_receivedRoutingKey", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setReceivedRoutingKey(arg_0)).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_redelivered", Boolean.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setRedelivered(arg_0)).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_replyTo", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setReplyTo(arg_0));
        Date timestamp = (Date)this.getHeaderIfAvailable(headers, "amqp_timestamp", Date.class);
        if (timestamp != null) {
            amqpMessageProperties.setTimestamp(timestamp);
        } else if (allHeaders != null && (ts = (Long)this.getHeaderIfAvailable(allHeaders, "timestamp", Long.class)) != null) {
            amqpMessageProperties.setTimestamp(new Date(ts));
        }
        JavaUtils.INSTANCE.acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_type", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setType(arg_0)).acceptIfNotNull(this.getHeaderIfAvailable(headers, "amqp_userId", String.class), arg_0 -> ((MessageProperties)amqpMessageProperties).setUserId(arg_0));
        this.mapJsonHeaders(headers, amqpMessageProperties);
        JavaUtils.INSTANCE.acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_springReplyCorrelation", String.class), replyCorrelation -> amqpMessageProperties.setHeader("spring_reply_correlation", replyCorrelation)).acceptIfHasText((String)this.getHeaderIfAvailable(headers, "amqp_springReplyToStack", String.class), replyToStack -> amqpMessageProperties.setHeader("spring_reply_to", replyToStack));
    }

    private void mapJsonHeaders(Map<String, Object> headers, MessageProperties amqpMessageProperties) {
        if (!amqpMessageProperties.getHeaders().containsKey("json__TypeId__".replaceFirst("json", ""))) {
            HashMap<String, String> jsonHeaders = new HashMap<String, String>();
            for (String jsonHeader : JsonHeaders.HEADERS) {
                Object value;
                if ("json_resolvableType".equals(jsonHeader) || (value = this.getHeaderIfAvailable(headers, jsonHeader, Object.class)) == null) continue;
                headers.remove(jsonHeader);
                if (value instanceof Class) {
                    value = ((Class)value).getName();
                }
                jsonHeaders.put(jsonHeader.replaceFirst("json", ""), value.toString());
            }
            amqpMessageProperties.getHeaders().putAll(jsonHeaders);
        }
    }

    protected void populateUserDefinedHeader(String headerName, Object headerValue, MessageProperties amqpMessageProperties) {
        if (!(amqpMessageProperties.getHeaders().containsKey(headerName) || "contentType".equals(headerName) || headerName.startsWith("json"))) {
            amqpMessageProperties.setHeader(headerName, headerValue);
        }
    }

    private String extractContentTypeAsString(Map<String, Object> headers) {
        String contentTypeStringValue = null;
        Object contentType = this.getHeaderIfAvailable(headers, "contentType", Object.class);
        if (contentType != null) {
            String contentTypeClassName = contentType.getClass().getName();
            if (contentType instanceof MimeType) {
                contentTypeStringValue = contentType.toString();
            } else if (contentType instanceof String) {
                contentTypeStringValue = (String)contentType;
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("skipping header 'contentType' since it is not of expected type [" + contentTypeClassName + "]"));
            }
        }
        return contentTypeStringValue;
    }

    public Map<String, Object> toHeadersFromRequest(MessageProperties source) {
        Map headersFromRequest = super.toHeadersFromRequest((Object)source);
        this.addConsumerMetadata(source, headersFromRequest);
        return headersFromRequest;
    }

    private void addConsumerMetadata(MessageProperties messageProperties, Map<String, Object> headers) {
        String consumerQueue;
        String consumerTag = messageProperties.getConsumerTag();
        if (consumerTag != null) {
            headers.put("amqp_consumerTag", consumerTag);
        }
        if ((consumerQueue = messageProperties.getConsumerQueue()) != null) {
            headers.put("amqp_consumerQueue", consumerQueue);
        }
    }

    public static DefaultAmqpHeaderMapper inboundMapper() {
        return new DefaultAmqpHeaderMapper(DefaultAmqpHeaderMapper.inboundRequestHeaders(), DefaultAmqpHeaderMapper.inboundReplyHeaders());
    }

    public static DefaultAmqpHeaderMapper outboundMapper() {
        return new DefaultAmqpHeaderMapper(DefaultAmqpHeaderMapper.outboundRequestHeaders(), DefaultAmqpHeaderMapper.outboundReplyHeaders());
    }

    public static String[] inboundRequestHeaders() {
        return new String[]{"*"};
    }

    public static String[] inboundReplyHeaders() {
        return DefaultAmqpHeaderMapper.safeOutboundHeaders();
    }

    public static String[] outboundRequestHeaders() {
        return DefaultAmqpHeaderMapper.safeOutboundHeaders();
    }

    public static String[] outboundReplyHeaders() {
        return new String[]{"*"};
    }

    private static String[] safeOutboundHeaders() {
        return new String[]{"!x-*", "*"};
    }

    static {
        STANDARD_HEADER_NAMES.add("amqp_appId");
        STANDARD_HEADER_NAMES.add("amqp_clusterId");
        STANDARD_HEADER_NAMES.add("amqp_contentEncoding");
        STANDARD_HEADER_NAMES.add("amqp_contentLength");
        STANDARD_HEADER_NAMES.add("contentType");
        STANDARD_HEADER_NAMES.add("amqp_correlationId");
        STANDARD_HEADER_NAMES.add("amqp_delay");
        STANDARD_HEADER_NAMES.add("amqp_deliveryMode");
        STANDARD_HEADER_NAMES.add("amqp_deliveryTag");
        STANDARD_HEADER_NAMES.add("amqp_expiration");
        STANDARD_HEADER_NAMES.add("amqp_messageCount");
        STANDARD_HEADER_NAMES.add("amqp_messageId");
        STANDARD_HEADER_NAMES.add("amqp_receivedDelay");
        STANDARD_HEADER_NAMES.add("amqp_receivedDeliveryMode");
        STANDARD_HEADER_NAMES.add("amqp_receivedExchange");
        STANDARD_HEADER_NAMES.add("amqp_receivedRoutingKey");
        STANDARD_HEADER_NAMES.add("amqp_redelivered");
        STANDARD_HEADER_NAMES.add("amqp_replyTo");
        STANDARD_HEADER_NAMES.add("amqp_timestamp");
        STANDARD_HEADER_NAMES.add("amqp_type");
        STANDARD_HEADER_NAMES.add("amqp_userId");
        STANDARD_HEADER_NAMES.add("json__TypeId__");
        STANDARD_HEADER_NAMES.add("json__ContentTypeId__");
        STANDARD_HEADER_NAMES.add("json__KeyTypeId__");
        STANDARD_HEADER_NAMES.add("amqp_springReplyCorrelation");
        STANDARD_HEADER_NAMES.add("amqp_springReplyToStack");
    }
}

