/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.ReturnedMessage;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.Lifecycle;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.amqp.outbound.AbstractAmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.MappingUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class AmqpOutboundEndpoint
extends AbstractAmqpOutboundEndpoint
implements RabbitTemplate.ConfirmCallback,
RabbitTemplate.ReturnsCallback {
    private static final Duration DEFAULT_CONFIRM_TIMEOUT = Duration.ofSeconds(5L);
    private final AmqpTemplate amqpTemplate;
    private final RabbitTemplate rabbitTemplate;
    private boolean expectReply;
    private boolean waitForConfirm;
    private Duration waitForConfirmTimeout = DEFAULT_CONFIRM_TIMEOUT;
    private boolean multiSend;

    public AmqpOutboundEndpoint(AmqpTemplate amqpTemplate) {
        Assert.notNull((Object)amqpTemplate, (String)"amqpTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
        if (amqpTemplate instanceof RabbitTemplate) {
            this.setConnectionFactory(((RabbitTemplate)amqpTemplate).getConnectionFactory());
            this.rabbitTemplate = (RabbitTemplate)amqpTemplate;
        } else {
            this.rabbitTemplate = null;
        }
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setWaitForConfirm(boolean waitForConfirm) {
        this.waitForConfirm = waitForConfirm;
    }

    public String getComponentType() {
        return this.expectReply ? "amqp:outbound-gateway" : "amqp:outbound-channel-adapter";
    }

    public void setMultiSend(boolean multiSend) {
        Assert.isTrue((this.rabbitTemplate != null && (!this.waitForConfirm || this.rabbitTemplate.getConnectionFactory().isSimplePublisherConfirms()) ? 1 : 0) != 0, () -> "To use multiSend, " + this.amqpTemplate + " must be a RabbitTemplate with a ConnectionFactory configured with simple confirms");
        this.multiSend = multiSend;
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return this.expectReply ? super.getIntegrationPatternType() : IntegrationPatternType.outbound_channel_adapter;
    }

    @Override
    public RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    @Override
    protected void endpointInit() {
        Duration confirmTimeout;
        if (this.getConfirmCorrelationExpression() != null) {
            Assert.notNull((Object)this.rabbitTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
            this.rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
        }
        if (this.getReturnChannel() != null) {
            Assert.notNull((Object)this.rabbitTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
            this.rabbitTemplate.setReturnsCallback((RabbitTemplate.ReturnsCallback)this);
        }
        if ((confirmTimeout = this.getConfirmTimeout()) != null) {
            this.waitForConfirmTimeout = confirmTimeout;
        }
    }

    @Override
    protected void doStop() {
        if (this.amqpTemplate instanceof Lifecycle) {
            ((Lifecycle)this.amqpTemplate).stop();
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        CorrelationData correlationData = this.generateCorrelationData(requestMessage);
        String exchangeName = this.generateExchangeName(requestMessage);
        String routingKey = this.generateRoutingKey(requestMessage);
        if (this.expectReply) {
            return this.sendAndReceive(exchangeName, routingKey, requestMessage, correlationData);
        }
        if (this.multiSend && requestMessage.getPayload() instanceof Iterable) {
            this.multiSend(requestMessage, exchangeName, routingKey);
            return null;
        }
        this.send(exchangeName, routingKey, requestMessage, correlationData);
        if (this.waitForConfirm && correlationData != null) {
            this.waitForConfirm(requestMessage, correlationData);
        }
        return null;
    }

    private void multiSend(Message<?> requestMessage, String exchangeName, String routingKey) {
        ((Iterable)requestMessage.getPayload()).forEach(payload -> Assert.state((boolean)(payload instanceof Message), (String)"To use multiSend, the payload must be an Iterable<Message<?>>"));
        this.rabbitTemplate.invoke(template -> {
            ((Iterable)requestMessage.getPayload()).forEach(message -> this.doRabbitSend(exchangeName, routingKey, (Message<?>)message, null, (RabbitTemplate)template));
            if (this.waitForConfirm) {
                template.waitForConfirmsOrDie(this.waitForConfirmTimeout.toMillis());
            }
            return null;
        });
    }

    private void waitForConfirm(Message<?> requestMessage, CorrelationData correlationData) {
        try {
            CorrelationData.Confirm confirm = (CorrelationData.Confirm)correlationData.getFuture().get(this.waitForConfirmTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!confirm.isAck()) {
                throw new AmqpException("Negative publisher confirm received: " + confirm);
            }
            if (correlationData.getReturnedMessage() != null) {
                throw new AmqpException("Message was returned by the broker");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new AmqpException("Failed to get publisher confirm", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new MessageTimeoutException(requestMessage, (Object)((Object)this) + ": Timed out awaiting publisher confirm", (Throwable)e);
        }
    }

    private void send(String exchangeName, String routingKey, Message<?> requestMessage, CorrelationData correlationData) {
        if (this.rabbitTemplate != null) {
            this.doRabbitSend(exchangeName, routingKey, requestMessage, correlationData, this.rabbitTemplate);
        } else {
            this.amqpTemplate.convertAndSend(exchangeName, routingKey, requestMessage.getPayload(), message -> {
                this.getHeaderMapper().fromHeadersToRequest(requestMessage.getHeaders(), message.getMessageProperties());
                return message;
            });
        }
    }

    private void doRabbitSend(String exchangeName, String routingKey, Message<?> requestMessage, CorrelationData correlationData, RabbitTemplate template) {
        MessageConverter converter = template.getMessageConverter();
        org.springframework.amqp.core.Message amqpMessage = MappingUtils.mapMessage(requestMessage, converter, this.getHeaderMapper(), this.getDefaultDeliveryMode(), this.isHeadersMappedLast());
        this.addDelayProperty(requestMessage, amqpMessage);
        template.send(exchangeName, routingKey, amqpMessage, correlationData);
    }

    private AbstractIntegrationMessageBuilder<?> sendAndReceive(String exchangeName, String routingKey, Message<?> requestMessage, CorrelationData correlationData) {
        Assert.state((this.rabbitTemplate != null ? 1 : 0) != 0, (String)"RabbitTemplate implementation is required for publisher confirms");
        MessageConverter converter = this.rabbitTemplate.getMessageConverter();
        org.springframework.amqp.core.Message amqpMessage = MappingUtils.mapMessage(requestMessage, converter, this.getHeaderMapper(), this.getDefaultDeliveryMode(), this.isHeadersMappedLast());
        this.addDelayProperty(requestMessage, amqpMessage);
        org.springframework.amqp.core.Message amqpReplyMessage = this.rabbitTemplate.sendAndReceive(exchangeName, routingKey, amqpMessage, correlationData);
        if (amqpReplyMessage == null) {
            return null;
        }
        return this.buildReply(converter, amqpReplyMessage);
    }

    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        this.handleConfirm(correlationData, ack, cause);
    }

    public void returnedMessage(ReturnedMessage returnedMessage) {
        MessageConverter converter = this.rabbitTemplate.getMessageConverter();
        Message<?> returned = this.buildReturnedMessage(returnedMessage, converter);
        this.getReturnChannel().send(returned);
    }
}

